<?php
	
	require_once ('classes/class.dbutil.php');
	require_once ('classes/class.users.php');
	require_once ('classes/class.user.php');
	require_once ('classes/class.buildings.php');
	require_once ('classes/class.building.php');
	require_once ('config.php');

	$DB = new DBUtil(DB_HOST,		// Nazwa hosta serwera bazy danych
				 	 DB_USER,		// Użytkownik bazy danych
				 	 DB_PASSWORD,	// Hasło użytkownika bazy danych
				 	 DB_NAME);		// Nazwa bazy danych

	if ($DB) {
		$UserUtil = new UserUtil($DB);
		$BuildingUtil = new BuildingUtil($DB);
		
		$user = new User(null, 'example', 'test@test.com');
		$user->setPassword('a-password');
		$user = $UserUtil->create($user);
		
		if ($user != null) {
			echo '<strong>UserUtil->create()</strong>';
			echo '<pre>';
			print_r($user);
			echo '</pre>';
		} else {
			echo "Podczas tworzenia użytkownika wystąpił błąd";
		}
		
		if ($user != null) {
			$id = $user->getId();
			
			$user2 = $UserUtil->getUserById($id);
			
			if ($user2 != null) {
				echo '<strong>UserUtil->getUserById()</strong>';
				echo '<pre>';
				print_r($user2);
				echo '</pre>';
			} else {
				echo "Podczas pobierania użytkownika po ID wystąpił błąd";
			}
		}
		
		if ($user != null) {
			if ($UserUtil->removeUser($user)) {
				echo '<strong>UserUtil->remove()</strong>';
				echo '<br />OK';
			} else {
				echo "Podczas usuwania użytkownika z bazy danych wystąpił błąd";
			}
		}

		echo "<br /><br />";
		
		$building = new Building(null, 'example', 'test@test.com');
		$building = $BuildingUtil->create($building);
		
		if ($building != null) {
			echo '<strong>BuildingUtil->create()</strong>';
			echo '<pre>';
			print_r($building);
			echo '</pre>';
		} else {
			echo "Podczas tworzenia budynku wystąpił błąd";
		}
		
		if ($building != null) {
			$id = $building->getId();
			
			$building2 = $BuildingUtil->getBuildingById($id);
			
			if ($building2 != null) {
				echo '<strong>BuildingUtil->getBuildingById()</strong>';
				echo '<pre>';
				print_r($building2);
				echo '</pre>';
			} else {
				echo "Podczas pobierania budynku po ID wystąpił błąd";
			}
		}
		
		if ($building != null) {
			if ($BuildingUtil->removeBuilding($building)) {
				echo '<strong>BuildingUtil->remove()</strong>';
				echo '<br />OK<br/><br />';
			} else {
				echo "Podczas usuwania budynku z bazy danych wystąpił błąd";
			}
		}
		
	} else {
		echo "Problem z połączeniem z bazą danych";
	}
?>
