// GUI

function initializeGUI(ui, canvas, g) {

	// Usuń klasę "hide" z GUI, by się pojawiło.
	ui.setAttribute("class", "");

	// Ustaw funkcje nasłuchujące zdarzeń
	window.addEventListener('resize', function() { g.doResize(); }, false);
	canvas.addEventListener(pointer.DOWN, function(e) { g.handleMouseDown(e); }, false);
	canvas.addEventListener(pointer.MOVE, function(e) { g.handleDrag(e); }, false);
	window.addEventListener(pointer.UP, function(e) { g.handleMouseUp(e); }, false);

	if (Modernizr.touch){
		// Wykryj gesty
		window.addEventListener('ongestureend', function(e) { g.handleGestureEnd(e); }, false);

		// Orientacja urządzenia
		if (window.orientation) {
			window.addEventListener('orientationchange', g.handleOrientationChange, false);		
		}
	} else {
		window.addEventListener('keydown', function(e) { g.handleKeyDown(e); }, false);

		// Przewijanie kółkiem myszy
		window.addEventListener('mousewheel', function(e) { g.handleScroll(e); }, false);
		window.addEventListener('DOMMouseScroll', function(e) { g.handleScroll(e); }, false);
	}

	// Nasłuchiwanie zdarzeń GUI
	ui.addEventListener(pointer.UP, function(e) {
		switch(e.target.getAttribute('id')) {
			case 'panel-toggle':
				var panelContainer = document.getElementById('panel-container');
				var classes = panelContainer.getAttribute('class');

				if (classes != null && classes.length > 0) {
					panelContainer.setAttribute('class', '');
					document.getElementById('panel-toggle').innerHTML = 'Cancel';
				} else {
					panelContainer.setAttribute('class', 'hidden');
					document.getElementById('panel-toggle').innerHTML = 'Build';
				}
				break;
			case 'select':
				selectTool(Tools.SELECT, document.getElementById('select'));
				break;
			case 'move':
				selectTool(Tools.MOVE, document.getElementById('move'));
				break;
			case 'zoomIn':
				selectTool(Tools.ZOOM_IN, document.getElementById('zoomIn'));
				break;
			case 'zoomOut':
				selectTool(Tools.ZOOM_OUT, document.getElementById('zoomOut'));
				break;
			case 'rotate':
				g.rotateGrid();
				g.draw();
				break;
			case 'demolish':
				selectTool(Tools.DEMOLISH, document.getElementById('demolish'));
				break;
			default:
				// Sprawdź kliknięcia opcji w panelu
				if ((e.target.tagName === 'LI' || e.target.parentNode.tagName === 'LI')) {
					var t = (e.target.tagName === 'LI') ? e.target : e.target.parentNode;
					var props = t.getAttribute("info");

					if (props !== undefined) {
						props = JSON.parse(props);

						var obj;


						switch(parseInt(props.buildingId)) {
							case 1: // Lodziarnia
								obj = new IceCreamShop();
								break;	
							case 2: // Hotel
								obj = new Hotel();
								break;
							case 3: // Kino
								obj = new Cinema();
								break;
							default: // Drzewo (4) lub inny obiekt.
								obj = new Tree();
								break;
						}

						g.buildHelper.current = obj;
						Tools.current = Tools.BUILD;
						break;
					}
				}

				// Nie została kliknięta żadna opcja, tylko pusty obszar ekranu.
				e.srcElement = canvas;
				e.target = canvas;
				e.toElement = canvas;
				
				g.handleMouseDown(e);

				break;
		}
	}, false);
}

function refresh() {
	var processResponse = function(resp) {
    	if (resp.substr(0, 5) == 'ERROR') {
			alert("Podczas synchronizacji pojawił się problem.");
		} else {
			var balanceContainer = document.getElementById('balance');

			var currBalance = parseInt(balanceContainer.innerHTML);
			var balance = parseInt(resp.substr(3, resp.length));
			balanceContainer.innerHTML = balance;
		}
	}

	sync(processResponse);

	setTimeout(function() { 
		refresh(ui); 
	}, 15000);
}

function selectTool(tool, elem) {

	// Usuń klasę "active" z elementów wewnątrz div#tools ul
	for (var i = 0, x = elem.parentNode.childNodes.length; i < x; i++) {
		if (elem.parentNode.childNodes[i].tagName == "LI") {
			elem.parentNode.childNodes[i].className = null;
		}
	}

	elem.setAttribute('class', 'active');

	switch(tool) {
		case Tools.SELECT:
			Tools.current = Tools.SELECT;
			break;
		case Tools.MOVE:
			Tools.current = Tools.MOVE;
			break;
		case Tools.ZOOM_IN:
			Tools.current = Tools.ZOOM_IN;
			break;
		case Tools.ZOOM_OUT:
			Tools.current = Tools.ZOOM_OUT;
			break;
		case Tools.DEMOLISH:
			Tools.current = Tools.DEMOLISH;
			break;
	}

}
