<?php

	header('Content-Type: application/json');

	// Dołącza definicje klas przed wywołaniem session_start()
	require_once ('../../server/classes/class.dbutil.php');
	require_once ('../../server/classes/class.users.php');
	require_once ('../../server/classes/class.buildings.php');
	require_once ('../../server/classes/class.operations.php');
	require_once ('../../server/classes/class.user.php');
	require_once ('../../server/config.php');

	session_start();

	if (count($_GET) != 0 && isset($_SESSION['userSession'])) {

		// Sprawdza, czy wszystkie parametry mają prawidłowe wartości
		if (!is_numeric($_GET['x']) ||
			!is_numeric($_GET['y']) ||
			intval($_GET['x']) < 0 ||
			intval($_GET['y']) < 0 ||
			intval($_GET['x']) > GRID_X ||
			intval($_GET['y']) > GRID_Y) {
			die('ERROR');
		}

	  $DB = new DBUtil(DB_HOST,		// Nazwa hosta serwera bazy danych
				   	 DB_USER,		// Użytkownik bazy danych
				   	 DB_PASSWORD,	// Hasło użytkownika bazy danych
				   	 DB_NAME);		// Nazwa bazy danych

		if ($DB) {
			$UserUtil = new UserUtil($DB);
			$OperUtil = new OperationsUtil($DB);

			$user = $UserUtil->getUserById($_SESSION['userSession']->getId());
			
			// Czy w podanej lokalizacji cokolwiek się znajduje?
			$inst = $OperUtil->findBuildingInstanceByXY($user->getId(), $_GET['x'], $_GET['y']);

			if ($inst) {
				$OperUtil->removeInstance($inst);

				die('OK');
			} else {
				die('ERROR');
			}

		}
	} else {
		die('ERROR');
	}
?>
