// Tworzenie serwera HTTP
var http = require("http");

// Tworzenie prostego serwera WWW, który zwróci taką samą odpowiedź na każde żądanie
var server = http.createServer(function(request, response) {
    console.log("Otrzymano żądanie HTTP dla adresu URL", request.url);

    response.writeHead(200, { "Content-Type": "text/plain" });
    response.end("To jest prosty serwer HTTP w node.js.");
});

// Nasłuchujemy na porcie 8080
server.listen(8080, function() {
    console.log("Serwer rozpoczął nasłuch na porcie 8080");
});

// Dołączamy serwer WebSocket do serwera HTTP
var WebSocketServer = require("websocket").server;
var wsServer = new WebSocketServer({
    httpServer: server
});

// Logika sprawdzająca, czy określone połączenie jest dozwolone
function connectionIsAllowed(request) {
    // Sprawdzamy kryteria takie jak request.origin, request.remoteAddress
    // Zwracamy false, aby zapobiec połączeniu, a true aby zezwolić na połączenie
    return true;
}

// Obsługa żądania połączenia poprzez WebSocket
wsServer.on("request", function(request) {
    // Odrzucamy żądania na podstawie określonych kryteriów
    if (!connectionIsAllowed(request)) {
        request.reject();
        console.log("Połączenie WebSocket z " + request.remoteAddress + " zostało odrzucone.");

        return;
    }

    // Akceptujemy połączenie
    var websocket = request.accept();

    console.log("Połączenie WebSocket z " + request.remoteAddress + " zostało zaakceptowane.");
    websocket.send("Cześć. Połączyłeś się z serwerem WebSocket");

    websocket.on("message", function(message) {
        if (message.type === "utf8") {
            console.log("Otrzymano wiadomość: " + message.utf8Data);
            websocket.send("Serwer otrzymał Twoją wiadomość: " + message.utf8Data);
        }
    });

    websocket.on("close", function(reasonCode, description) {
        console.log("Połączenie WebSocket z " + request.remoteAddress + " zostało zakończone.");
    });
});