/* Szczegóły map wykorzystywanych w poziomach */
var maps = {
    "plains": {
        "mapImage": "plains.png",

        /* Dane dotyczące terenu - automatycznie wygenerowane przez skrypt level/convert-levels.js */
        "mapGridWidth": 60,
        "mapGridHeight": 40,
        "mapObstructedTerrain": [[0, 0], [1, 0], [2, 0], [26, 0], [27, 0], [28, 0], [29, 0], [30, 0], [31, 0], [32, 0], [33, 0], [44, 0], [45, 0], [46, 0], [47, 0], [48, 0], [49, 0], [50, 0], [51, 0], [52, 0], [53, 0], [54, 0], [55, 0], [56, 0], [58, 0], [59, 0], [0, 1], [1, 1], [2, 1], [25, 1], [26, 1], [27, 1], [28, 1], [29, 1], [30, 1], [31, 1], [32, 1], [45, 1], [46, 1], [47, 1], [48, 1], [49, 1], [50, 1], [51, 1], [52, 1], [53, 1], [54, 1], [55, 1], [56, 1], [58, 1], [59, 1], [12, 2], [13, 2], [14, 2], [25, 2], [26, 2], [27, 2], [28, 2], [29, 2], [30, 2], [31, 2], [45, 2], [46, 2], [47, 2], [48, 2], [49, 2], [50, 2], [51, 2], [52, 2], [53, 2], [54, 2], [55, 2], [56, 2], [58, 2], [59, 2], [10, 3], [11, 3], [12, 3], [13, 3], [14, 3], [25, 3], [26, 3], [27, 3], [29, 3], [30, 3], [31, 3], [47, 3], [48, 3], [49, 3], [50, 3], [51, 3], [52, 3], [53, 3], [54, 3], [55, 3], [58, 3], [59, 3], [10, 4], [11, 4], [12, 4], [13, 4], [14, 4], [15, 4], [48, 4], [49, 4], [50, 4], [51, 4], [52, 4], [53, 4], [58, 4], [59, 4], [10, 5], [11, 5], [12, 5], [13, 5], [14, 5], [15, 5], [48, 5], [49, 5], [50, 5], [51, 5], [58, 5], [59, 5], [13, 6], [14, 6], [15, 6], [49, 6], [50, 6], [51, 6], [52, 6], [53, 6], [54, 6], [58, 6], [59, 6], [15, 7], [19, 7], [49, 7], [50, 7], [51, 7], [52, 7], [53, 7], [54, 7], [58, 7], [59, 7], [32, 8], [33, 8], [34, 8], [49, 8], [50, 8], [51, 8], [52, 8], [53, 8], [54, 8], [58, 8], [59, 8], [3, 9], [4, 9], [5, 9], [32, 9], [33, 9], [34, 9], [49, 9], [50, 9], [51, 9], [52, 9], [53, 9], [58, 9], [59, 9], [3, 10], [4, 10], [5, 10], [6, 10], [7, 10], [8, 10], [9, 10], [11, 10], [12, 10], [13, 10], [32, 10], [33, 10], [34, 10], [49, 10], [50, 10], [51, 10], [52, 10], [53, 10], [58, 10], [59, 10], [3, 11], [4, 11], [5, 11], [6, 11], [7, 11], [8, 11], [9, 11], [10, 11], [11, 11], [12, 11], [13, 11], [49, 11], [50, 11], [51, 11], [52, 11], [53, 11], [58, 11], [59, 11], [5, 12], [6, 12], [7, 12], [8, 12], [9, 12], [10, 12], [11, 12], [12, 12], [13, 12], [29, 12], [48, 12], [49, 12], [50, 12], [51, 12], [52, 12], [53, 12], [5, 13], [6, 13], [7, 13], [30, 13], [34, 13], [35, 13], [36, 13], [48, 13], [49, 13], [50, 13], [51, 13], [52, 13], [53, 13], [5, 14], [6, 14], [7, 14], [20, 14], [21, 14], [34, 14], [35, 14], [36, 14], [48, 14], [49, 14], [50, 14], [51, 14], [52, 14], [53, 14], [34, 15], [35, 15], [36, 15], [49, 15], [50, 15], [51, 15], [52, 15], [53, 15], [47, 16], [48, 16], [49, 16], [50, 16], [51, 16], [52, 16], [53, 16], [44, 17], [47, 17], [48, 17], [49, 17], [50, 17], [51, 17], [52, 17], [16, 18], [17, 18], [18, 18], [47, 18], [48, 18], [49, 18], [50, 18], [51, 18], [52, 18], [9, 19], [10, 19], [11, 19], [16, 19], [17, 19], [18, 19], [43, 19], [44, 19], [45, 19], [46, 19], [47, 19], [48, 19], [50, 19], [51, 19], [52, 19], [9, 20], [10, 20], [11, 20], [16, 20], [17, 20], [18, 20], [43, 20], [44, 20], [45, 20], [46, 20], [47, 20], [48, 20], [9, 21], [10, 21], [11, 21], [24, 21], [25, 21], [26, 21], [30, 21], [31, 21], [32, 21], [43, 21], [44, 21], [45, 21], [46, 21], [47, 21], [48, 21], [24, 22], [25, 22], [26, 22], [27, 22], [28, 22], [29, 22], [30, 22], [31, 22], [32, 22], [41, 22], [42, 22], [43, 22], [44, 22], [45, 22], [46, 22], [47, 22], [48, 22], [49, 22], [50, 22], [24, 23], [25, 23], [26, 23], [27, 23], [28, 23], [29, 23], [30, 23], [31, 23], [32, 23], [41, 23], [42, 23], [43, 23], [44, 23], [45, 23], [46, 23], [47, 23], [48, 23], [49, 23], [50, 23], [25, 24], [26, 24], [27, 24], [28, 24], [29, 24], [41, 24], [42, 24], [43, 24], [44, 24], [45, 24], [46, 24], [47, 24], [48, 24], [49, 24], [50, 24], [2, 25], [3, 25], [4, 25], [24, 25], [25, 25], [26, 25], [27, 25], [28, 25], [29, 25], [43, 25], [44, 25], [45, 25], [46, 25], [47, 25], [2, 26], [3, 26], [4, 26], [24, 26], [25, 26], [26, 26], [27, 26], [28, 26], [29, 26], [43, 26], [44, 26], [45, 26], [46, 26], [47, 26], [2, 27], [3, 27], [4, 27], [24, 27], [25, 27], [26, 27], [27, 27], [28, 27], [29, 27], [43, 27], [44, 27], [45, 27], [46, 27], [47, 27], [25, 28], [26, 28], [27, 28], [28, 28], [29, 28], [43, 28], [44, 28], [45, 28], [46, 28], [47, 28], [54, 28], [8, 29], [9, 29], [23, 29], [24, 29], [25, 29], [26, 29], [27, 29], [28, 29], [29, 29], [43, 29], [44, 29], [45, 29], [46, 29], [47, 29], [59, 29], [9, 30], [23, 30], [24, 30], [25, 30], [26, 30], [27, 30], [28, 30], [43, 30], [44, 30], [45, 30], [46, 30], [47, 30], [59, 30], [23, 31], [24, 31], [25, 31], [26, 31], [27, 31], [28, 31], [36, 31], [59, 31], [17, 32], [18, 32], [19, 32], [25, 32], [26, 32], [27, 32], [28, 32], [46, 32], [55, 32], [59, 32], [17, 33], [18, 33], [19, 33], [23, 33], [24, 33], [25, 33], [26, 33], [27, 33], [28, 33], [33, 33], [34, 33], [35, 33], [59, 33], [17, 34], [18, 34], [19, 34], [23, 34], [24, 34], [25, 34], [26, 34], [27, 34], [28, 34], [33, 34], [34, 34], [35, 34], [59, 34], [23, 35], [24, 35], [25, 35], [26, 35], [27, 35], [28, 35], [33, 35], [34, 35], [35, 35], [59, 35], [24, 36], [25, 36], [26, 36], [27, 36], [28, 36], [59, 36], [22, 37], [23, 37], [24, 37], [25, 37], [26, 37], [27, 37], [28, 37], [59, 37], [22, 38], [23, 38], [24, 38], [25, 38], [26, 38], [27, 38], [59, 38], [22, 39], [23, 39], [24, 39], [25, 39], [26, 39], [27, 39], [48, 39], [49, 39], [50, 39], [51, 39], [52, 39], [53, 39], [54, 39], [55, 39], [56, 39], [57, 39], [58, 39], [59, 39]],
    }
};

/* Rzeczywiste poziomy gry */
var levels = {
    "singleplayer": [
        {
            "name": "Ratunek",
            "briefing": "W ostatnich miesiącach przed wybuchem wojny, ludzkość pogrążyła się w chaosie. Miliardy ludzi zmarło, a miasta obróciły się w ruinę.\nNiewielkie grupy ocalałych połączyły się w próbie przetrwania.\nPróbujemy dotrzeć do wszystkich ocalałych w tym sektorze, zanim powrócimy do głównej kolonii.",

            /* Szczegóły mapy */
            "mapName": "plains",
            "startX": 36,
            "startY": 0,

            /* Encje, które należy wczytać */
            "requirements": {
                "buildings": ["base"],
                "vehicles": ["transport", "scout-tank", "heavy-tank"],
                "aircraft": [],
                "terrain": []
            },

            /* Encje, które należy dodać */
            "items": [
                /* Nieco uszkodzona baza */
                { "type": "buildings", "name": "base", "x": 55, "y": 6, "team": "blue", "life": 100 },

                /* Nasz czołg */
                { "type": "vehicles", "name": "heavy-tank", "uid": -1, "x": 57, "y": 12, "direction": 4, "team": "blue" },

                /* Dwa transportery czekające na ratunek, znajdujące się tuż poza widoczną częścią mapy */
                { "type": "vehicles", "name": "transport", "uid": -3, "selectable": false, "x": -3, "y": 2, "direction": 2, "team": "blue" },
                { "type": "vehicles", "name": "transport", "uid": -4, "selectable": false, "x": -3, "y": 4, "direction": 2, "team": "blue" },

                /* Dwa uszkodzone nieprzyjacielskie czołgi zwiadowcze patrolujące teren*/
                { "type": "vehicles", "name": "scout-tank", "uid": -2, "x": 40, "y": 20, "direction": 4, "team": "green", "life": 20, "orders": { "type": "patrol", "from": { "x": 34, "y": 20 }, "to": { "x": 42, "y": 25 } } },
                { "type": "vehicles", "name": "scout-tank", "uid": -5, "x": 14, "y": 0, "direction": 4, "team": "green", "life": 20, "orders": { "type": "patrol", "from": { "x": 14, "y": 0 }, "to": { "x": 14, "y": 14 } } },

            ],

            "cash": {
                "blue": 0,
                "green": 0
            },

            /* Warunkowe i czasowe zdarzenia wyzwalaczy */
            "triggers": [
                {
                    "type": "timed", "time": 3000,
                    // Nakazujemy graczowi szukanie konwoju
                    "action": function() {
                        game.showMessage("op", "Komandorze!! Od dwóch godzin nie mamy wieści od ostatniego konwoju. Powinni już dotrzeć.");
                    }
                },
                {
                    "type": "timed", "time": 10000,
                    // Wyświetlamy graczowi wskazówkę ułatwiającą znalezienie konwoju
                    "action": function() {
                        game.showMessage("op", "Ostatnio widziano ich w Sektorze Północnozachodnim. Czy możesz to sprawdzić?");
                    }
                },
                {
                    "type": "conditional",
                    // Sprawdzamy, czy nasz czołg lub dwa pojazdy konwoju są zniszczone
                    "condition": function() {
                        return (game.isItemDead(-1) || game.isItemDead(-3) || game.isItemDead(-4));
                    },
                    // Kończymy misję niepowodzeniem
                    "action": function() {
                        singleplayer.endLevel(false);
                    }
                },
                {
                    "type": "conditional",
                    // Sprawdzamy, czy pierwszy nieprzyjaciel jest uszkodzony
                    "condition": function() {
                        return game.isItemDead(-2);
                    },
                    // Komentujemy agresję rebeliantów
                    "action": function() {
                        game.showMessage("op", "Rebelianci stali się ostatnio bardzo agresywni. Mam nadzieję, że konwój jest bezpieczny. Znajdź go i zapewnij eskortę do bazy.");
                    }
                },
                {
                    "type": "conditional",
                    // Sprawdzamy, czy bohater dotarł do górnego lewego fragmentu mapy
                    "condition": function() {
                        let hero = game.getItemByUid(-1);

                        return (hero && hero.x < 30 && hero.y < 30);
                    },
                    // Wyświetlamy wiadomość od zaniepokojonego kierowcy
                    "action": function() {
                        game.showMessage("driver", "Czy ktoś nas słyszy? Nasz konwój został pokonany przez czołgi rebeliantów. Potrzebujemy pomocy.");
                    }
                },
                {
                    "type": "conditional",
                    // Sprawdzamy, czy gracz znajduje się niedaleko konwoju
                    "condition": function() {
                        let hero = game.getItemByUid(-1);

                        return (hero && hero.x < 10 && hero.y < 10);
                    },
                    // Wyświetlamy podziękowanie kierowcy i nakazujemy konwojowi podążanie za bohaterem
                    "action": function() {
                        var hero = game.getItemByUid(-1);

                        game.showMessage("driver", "Dziękuję. Myśleliśmy, że nie wyjdziemy z tego cało.");
                        game.sendCommand([-3, -4], { type: "guard", to: hero });
                    }
                },
                {
                    "type": "conditional",
                    // Sprawdzamy, czy pojazdy konwoju znajdują się w pobliżu bazy
                    "condition": function() {
                        var transport1 = game.getItemByUid(-3);
                        var transport2 = game.getItemByUid(-4);

                        return (transport1 && transport2 && transport1.x > 52 && transport2.x > 52 && transport2.y < 18 && transport1.y < 18);
                    },
                    // Kończymy misję z powodzeniem
                    "action": function() {
                        singleplayer.endLevel(true);
                    }
                },
            ],
        },

        {
            "name": "Napad",
			"briefing": "Dzięki dostawom z konwoju, nasza baza jest gotowa do działania.\n Rebelianci znajdujący się w pobliżu sprawiają nam kłopoty. Musimy się ich pozbyć. \n Najpierw zadbamy o ochronę bazy. Następnie znajdziemy i zniszczymy wszystkich rebeliantów z okolicy.\n Kolonia będzie wysyłać posiłki, które nam pomogą.",

            /* Szczegóły mapy */
            "mapName": "plains",
            "startX": 36,
            "startY": 0,


            /* Encje, które należy wczytać */
            "requirements": {
                "buildings": ["base", "ground-turret", "starport", "harvester"],
                "vehicles": ["transport", "scout-tank", "heavy-tank"],
                "aircraft": ["chopper"],
                "terrain": []
            },

            /* Aspekt finansowy*/
            "cash": {
                "blue": 0,
                "green": 0
            },

            /* Encje, które należy dodać */
            "items": [
                { "type": "buildings", "name": "base", "uid": -1, "x": 55, "y": 6, "team": "blue" },

                { "type": "buildings", "name": "ground-turret", "x": 53, "y": 17, "team": "blue" },
                { "type": "vehicles", "name": "heavy-tank", "uid": -2, "x": 55, "y": 16, "direction": 4, "team": "blue", "orders": { "type": "sentry" } },

                /* Pierwsza fala ataku*/
                { "type": "vehicles", "name": "scout-tank", "x": 55, "y": 36, "direction": 4, "team": "green", "orders": { "type": "hunt" } },
                { "type": "vehicles", "name": "scout-tank", "x": 53, "y": 36, "direction": 4, "team": "green", "orders": { "type": "hunt" } },

                /* Wrogowie patrolujący teren */
                { "type": "vehicles", "name": "scout-tank", "x": 5, "y": 5, "direction": 4, "team": "green", "orders": { "type": "patrol", "from": { "x": 5, "y": 5 }, "to": { "x": 20, "y": 20 } } },
                { "type": "vehicles", "name": "scout-tank", "x": 5, "y": 15, "direction": 4, "team": "green", "orders": { "type": "patrol", "from": { "x": 5, "y": 15 }, "to": { "x": 20, "y": 30 } } },
                { "type": "vehicles", "name": "scout-tank", "x": 25, "y": 5, "direction": 4, "team": "green", "orders": { "type": "patrol", "from": { "x": 25, "y": 5 }, "to": { "x": 25, "y": 20 } } },
                { "type": "vehicles", "name": "scout-tank", "x": 35, "y": 5, "direction": 4, "team": "green", "orders": { "type": "patrol", "from": { "x": 35, "y": 5 }, "to": { "x": 35, "y": 30 } } },

                /* Baza rebeliantów*/
                { "type": "buildings", "name": "base", "uid": -11, "x": 5, "y": 36, "team": "green" },
                { "type": "buildings", "name": "starport", "uid": -12, "x": 1, "y": 30, "team": "green" },
                { "type": "buildings", "name": "starport", "uid": -13, "x": 4, "y": 32, "team": "green" },

                { "type": "buildings", "name": "harvester", "x": 1, "y": 38, "team": "green", "action": "deploy" },
                { "type": "buildings", "name": "ground-turret", "x": 5, "y": 28, "team": "green" },
                { "type": "buildings", "name": "ground-turret", "x": 7, "y": 33, "team": "green" },
                { "type": "buildings", "name": "ground-turret", "x": 8, "y": 37, "team": "green" },
            ],

            /* Warunkowe i czasowe zdarzenia wyzwalaczy */
            "triggers": [
                {
                    "type": "timed", "time": 8000,
                    // Wysyłamy posiłki, które ochronią nasz czołg przed pierwszą falą nieprzyjaciół
                    "action": function() {
                        game.showMessage("op", "Komandorze!! Przybyły posiłki z kolonii.");
                        let hero = game.getItemByUid(-2);

                        game.add({
                            "type": "vehicles",
                            "name": "scout-tank",
                            "team": "blue",
                            "x": 61, "y": 22,
                            "orders": { "type": "guard", "to": hero }
                        });
                        game.add({
                            "type": "vehicles",
                            "name": "scout-tank",
                            "team": "blue",
                            "x": 61, "y": 21,
                            "orders": { "type": "guard", "to": hero }
                        });
                    }
                },
                {
                    "type": "timed", "time": 25000,
                    // Dodatkowa gotówka
                    "action": function() {
                        game.cash["blue"] = 1500;
                        game.showMessage("op", "Komandorze!! Mamy wystarczająco dużo zasobów, aby kupić następne działko. Zainstaluj działko, aby ochronić bazę przed kolejnymi atakami.");
                    }
                },
                {
                    "type": "timed", "time": 60000, "repeat": true,
                    // Tworzymy kilka złych postaci, które będą polować na gracza, gdy tylko wróg zdobędzie wystarczającą ilość pieniędzy
                    "action": function() {
                        if (game.cash["green"] > 1000) {
                            game.sendCommand([-12, -13], {
                                type: "construct-unit",
                                details: { type: "vehicles", name: "scout-tank", orders: { "type": "hunt" } }
                            });
                        }
                    }
                },
                {
                    "type": "timed", "time": 180000, "repeat": true,
                    // Co każde trzy minuty wysyłamy więcej posiłków
                    "action": function() {
                        game.showMessage("op", "Komandorze!! Dotarły kolejne posiłki.");
                        game.add({
                            "type": "vehicles",
                            "name": "scout-tank",
                            "team": "blue",
                            "x": 61, "y": 22,
                            "orders": { "type": "move", "to": { "x": 55, "y": 21 } }
                        });
                        game.add({
                            "type": "vehicles",
                            "name": "heavy-tank",
                            "team": "blue",
                            "x": 61, "y": 23,
                            "orders": { "type": "move", "to": { "x": 56, "y": 23 } }
                        });
                    }
                },
                {
                    "type": "timed", "time": 600000,
                    // Wysyłamy wsparcie z powietrza, jeśli misja nie zakończy się w ciągu 10 minut
                    "action": function() {
                        game.showMessage("pilot", "Wsparcie powietrzne jest w drodze. Zrobimy wszystko co w naszej mocy, aby pomóc.");
                        game.add({
                            "type": "aircraft",
                            "name": "chopper",
                            "team": "blue",
                            "selectable": false,
                            "x": 61, "y": 22,
                            "orders": { "type": "hunt" }
                        });
                    }
                },
                {
                    "type": "conditional",
                    // Sprawdzamy, czy baza gracza uległa zniszczeniu
                    "condition": function() {
                        return game.isItemDead(-1);
                    },
                    // Kończymy poziom niepowodzeniem
                    "action": function() {
                        singleplayer.endLevel(false);
                    }
                },

                {
                    "type": "conditional",
                    // Sprawdzamy, czy baza wroga została choć w połowie zniszczona
                    "condition": function() {
                        let enemyBase = game.getItemByUid(-11);

                        return (!enemyBase || (enemyBase.life <= enemyBase.hitPoints / 2));
                    },
                    // Kończymy poziom sukcesem
                    "action": function() {
                        singleplayer.endLevel(true);
                    }
                },
            ]
        },

        {
            "name": "Pod oblężeniem",
    		"briefing": "Dzięki przeprowadzonemu atakowi, mamy kontrolę nad bazą rebeliantów. Możemy oczekiwać próby odwetu ze strony rebeliantów.\n Kolonia wysyła statek powietrzny, który ułatwi nam ewakuację do głównego obozu. Musimy tylko przetrwać, aż przylecą śmigłowce.\n Na szczęście mamy pewne zasoby i amunicję, aby się obronić do czasu ich przybycia. \n Za wszelką cenę musisz chronić wszystkie transporty.",

            /* Szczegóły mapy */
            "mapName": "plains",
            "startX": 0,
            "startY": 20,

            /* Encje, które należy wczytać */
            "requirements": {
                "buildings": ["base", "ground-turret", "starport", "harvester"],
                "vehicles": ["transport", "scout-tank", "heavy-tank"],
                "aircraft": ["chopper", "wraith"],
                "terrain": []
            },

            /* Aspekt finansowy*/
            "cash": {
                "blue": 500,
                "green": 0
            },

            /* Encje, które należy dodać */
            "items": [
                /* Baza rebeliantów znajdująca się w naszych rękach */
                { "type": "buildings", "name": "base", "uid": -11, "x": 5, "y": 36, "team": "blue" },
                { "type": "buildings", "name": "starport", "uid": -12, "x": 1, "y": 28, "team": "blue" },
                { "type": "buildings", "name": "starport", "uid": -13, "x": 4, "y": 32, "team": "blue" },
                { "type": "buildings", "name": "harvester", "x": 1, "y": 38, "team": "blue", "action": "deploy" },
                { "type": "buildings", "name": "ground-turret", "x": 7, "y": 28, "team": "blue" },
                { "type": "buildings", "name": "ground-turret", "x": 8, "y": 32, "team": "blue" },
                { "type": "buildings", "name": "ground-turret", "x": 11, "y": 37, "team": "blue" },

                /* Transportery, które należy chronić*/
                { "type": "vehicles", "name": "transport", "uid": -1, "x": 2, "y": 33, "team": "blue", "direction": 2, "selectable": false },
                { "type": "vehicles", "name": "transport", "uid": -2, "x": 1, "y": 34, "team": "blue", "direction": 2, "selectable": false },
                { "type": "vehicles", "name": "transport", "uid": -3, "x": 2, "y": 35, "team": "blue", "direction": 2, "selectable": false },
                { "type": "vehicles", "name": "transport", "uid": -4, "x": 1, "y": 36, "team": "blue", "direction": 2, "selectable": false },

                /* Pilot śmigłowca z ostatniej misji */
                {
                    "type": "aircraft",
                    "name": "chopper",
                    "x": 15, "y": 40,
                    "team": "blue",
                    "selectable": false,
                    "uid": -5,
                    "orders": { "type": "patrol", "from": { "x": 15, "y": 40 }, "to": { "x": 0, "y": 25 } }
                },

                /* Pierwsza fala ataku*/
                { "type": "vehicles", "name": "scout-tank", "x": 15, "y": 16, "direction": 4, "team": "green", "orders": { "type": "hunt" } },
                { "type": "vehicles", "name": "scout-tank", "x": 17, "y": 16, "direction": 4, "team": "green", "orders": { "type": "hunt" } },

                /* Sekretne bazy rebeliantów*/
                { "type": "buildings", "name": "starport", "uid": -23, "x": 35, "y": 37, "team": "green" },
                { "type": "buildings", "name": "starport", "uid": -24, "x": 33, "y": 37, "team": "green" },
                { "type": "buildings", "name": "harvester", "x": 28, "y": 39, "team": "green", "action": "deploy" },
                { "type": "buildings", "name": "harvester", "x": 30, "y": 39, "team": "green", "action": "deploy" },

                { "type": "buildings", "name": "starport", "uid": -21, "x": 3, "y": 0, "team": "green" },
                { "type": "buildings", "name": "starport", "uid": -22, "x": 6, "y": 0, "team": "green" },
                { "type": "buildings", "name": "harvester", "x": 0, "y": 2, "team": "green", "action": "deploy" },
                { "type": "buildings", "name": "harvester", "x": 0, "y": 4, "team": "green", "action": "deploy" },

            ],

            /* Warunkowe i czasowe zdarzenia wyzwalaczy */
            "triggers": [
                {
                    // Sprawdzamy, czy któryś z transporterów został zniszczony
                    "condition": function() {
                        return game.isItemDead(-1) || game.isItemDead(-2) || game.isItemDead(-3) || game.isItemDead(-4);
                    },
                    // Kończymy poziom niepowodzeniem
                    "action": function() {
                        singleplayer.endLevel(false);
                    }
                },
                {
                    "type": "timed", "time": 5000,
                    // Wyświetlamy ostrzeżenie o atakach
                    "action": function() {
                        game.showMessage("op", "Komandorze!! Rebelianci rozpoczęli atak. Za wszelką cenę musimy obronić bazę i chronić transportery.");
                    }
                },
                {
                    "type": "timed", "time": 20000,
                    // Dodajemy nowy pojazd transportowy w prawym górnym rogu mapy
                    "action": function() {
                        game.add({ "type": "vehicles", "name": "transport", "x": 57, "y": 3, "team": "blue", "direction": 4, "selectable": false, "uid": -6 });
                        game.showMessage("driver", "Komandorze!! Kolonia wysłała dodatkowe posiłki. Przybędziemy z północnowschodniego sektora i musimy się przedrzeć przez terytorium rebeliantów. Przydałaby się nam jakaś ochrona.");
                    }
                },
                {
                    "type": "timed", "time": 24000,
                    // Niech pilot ochrania nowy transport
                    "action": function() {
                        game.sendCommand([-5], { "type": "guard", "toUid": -6 });
                        game.showMessage("pilot", "Trzymaj się. Nadlatuję.");
                    }
                },

                {
                    "type": "timed", "time": 28000,
                    // Dodajemy kilka czarnych charakterów, aby urozmaicić grę
                    "action": function() {
                        game.add({ "type": "vehicles", "name": "scout-tank", "x": 57, "y": 28, "team": "green", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "wraith", "x": 55, "y": 33, "team": "green", "orders": { "type": "sentry" } });
                        game.add({ "type": "aircraft", "name": "wraith", "x": 53, "y": 33, "team": "green", "orders": { "type": "sentry" } });
                        game.add({ "type": "vehicles", "name": "scout-tank", "x": 35, "y": 25, "life": 20, "direction": 4, "team": "green", "orders": { "type": "patrol", "from": { "x": 35, "y": 25 }, "to": { "x": 35, "y": 30 } } });
                    }
                },
                {
                    "type": "timed", "time": 48000,
                    // Zaczynamy przesuwać transporter w kierunku bazy
                    "action": function() {
                        game.showMessage("driver", "Dziękuję! Doceniam wsparcie. Dobrze. Ruszamy więc.");
                        game.sendCommand([-6], { "type": "move", "to": { "x": 0, "y": 32 } });
                    }
                },
                {
                    "type": "conditional",
                    // Sprawdzamy, czy pilotka została zraniona
                    "condition": function() {
                        let pilot = game.getItemByUid(-5);

                        return pilot.life < pilot.hitPoints;
                    },
                    // Pilotka poprosi o pomoc
                    "action": function() {
                        game.showMessage("pilot", "Jesteśmy atakowani! Potrzebujemy wsparcia. To nie wygląda dobrze.");
                    }
                },
                { "type": "conditional",
                    // Sprawdzamy, czy nowy transport dotarł do bazy z posiłkami
                    "condition": function() {
                        let driver = game.getItemByUid(-6);

                        return driver && driver.x < 2 && driver.y > 30;
                    },
                    // Dajemy graczowi dodatkowe zasoby gotówki
                    "action": function() {
                        game.showMessage("driver", "Rebelianci pojawili się znikąd. Nie mogliśmy nic zrobić. Ona ocaliła nam życie. Mam nadzieję, że ta dostawa była tego warta.");
                        game.cash["blue"] += 1200;
                    }
                },
                {
                    "type": "timed", "time": 150000, "repeat": true,
                    // Co 150 sekund wysyłamy fale nieprzyjaciela
                    "action": function() {
                        // Liczniki statków powietrznych oraz czołgów dostępnych dla wroga
                        let wraithCount = 0;
                        let chopperCount = 0;
                        let scoutTankCount = 0;
                        let heavyTankCount = 0;

                        game.items.forEach(function(item) {
                            if (item.team === "green") {
                                switch (item.name) {
                                    case "chopper":
                                        chopperCount++;
                                        break;
                                    case "wraith":
                                        wraithCount++;
                                        break;
                                    case "scout-tank":
                                        scoutTankCount++;
                                        break;
                                    case "heavy-tank":
                                        heavyTankCount++;
                                        break;
                                }
                            }
                        }, this);

                        // Upewniamy się, że nieprzyjaciel ma co najmniej dwa myśliwce oraz dwa ciężkie czołgi oraz używa pozostałych stacji dokujących do tworzenia śmigłowców i czołgów zwiadowczych
                        if (wraithCount === 0) {
                            // Żaden myśliwiec nie jest dostępny. Nakazujemy budowanie myśliwców w obydwu  stacjach dokujących
                            game.sendCommand([-23, -24], { type: "construct-unit", details: { type: "aircraft", name: "wraith", "orders": { "type": "hunt" } } });
                        } else if (wraithCount === 1) {
                            // Jeden myśliwiec jest dostępny. Nakazujemy budowanie jednego myśliwca oraz jednego śmigłowca w stacji dokującej
                            game.sendCommand([-23], { type: "construct-unit", details: { type: "aircraft", name: "wraith", "orders": { "type": "hunt" } } });
                            game.sendCommand([-24], { type: "construct-unit", details: { type: "aircraft", name: "chopper", "orders": { "type": "hunt" } } });
                        } else {
                            // Dostępne są dwa myśliwce. Nakazujemy tworzenie śmigłowców w obydwu stacjach dokujących
                            game.sendCommand([-23, -24], { type: "construct-unit", details: { type: "aircraft", name: "chopper", "orders": { "type": "hunt" } } });
                        }

                        if (heavyTankCount === 0) {
                            // Nie pozostał żaden ciężki czołg. Nakazujemy budowanie ciężkich czołgów w stacjach dokujących
                            game.sendCommand([-21, -22], { type: "construct-unit", details: { type: "vehicles", name: "heavy-tank", "orders": { "type": "hunt" } } });
                        } else if (heavyTankCount === 1) {
                        // Pozostał jeden ciężki czołg. Nakazujemy produkcję jednego ciężkiego czołgu i jednego czołgu zwiadowczego w stacjach dokujących
                            game.sendCommand([-21], { type: "construct-unit", details: { type: "vehicles", name: "heavy-tank", "orders": { "type": "hunt" } } });
                            game.sendCommand([-22], { type: "construct-unit", details: { type: "vehicles", name: "scout-tank", "orders": { "type": "hunt" } } });
                        } else {
                            // Dostępne są dwa ciężkie czołgi. Nakazujemy produkcję czołgów zwiadowczych w obydwu stacjach dokujących
                            game.sendCommand([-21, -22], { type: "construct-unit", details: { type: "vehicles", name: "scout-tank", "orders": { "type": "hunt" } } });
                        }
                        // Nakazujemy atak wszystkim jednostkom nieprzyjaciela
                        let uids = [];

                        game.items.forEach(function(item) {
                            if (item.team === "green" && item.canAttack) {
                                uids.push(item.uid);
                            }
                        }, this);

                        game.sendCommand(uids, { "type": "hunt" });
                    }
                },
                {
                    "type": "timed", "time": 480000,
                    // Po 8 minutach zaczynamy się przygotowywać do zakończenia
                    "action": function() {
                        game.showMessage("op", "Commander!! The colony air fleet is just a few minutes away.");
                    }
                },
                {
                    "type": "timed", "time": 600000,
                    //Po 10 minutach wysyłamy posiłki
                    "action": function() {
                        game.showMessage("op", "Komandorze!! Flota powietrzna kolonii się zbliża");
                        game.add({ "type": "aircraft", "name": "wraith", "x": -1, "y": 28, "team": "blue", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "chopper", "x": -1, "y": 29, "team": "blue", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "wraith", "x": -1, "y": 30, "team": "blue", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "chopper", "x": -1, "y": 31, "team": "blue", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "wraith", "x": -1, "y": 32, "team": "blue", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "chopper", "x": -1, "y": 33, "team": "blue", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "wraith", "x": -1, "y": 34, "team": "blue", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "chopper", "x": -1, "y": 35, "team": "blue", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "wraith", "x": -1, "y": 36, "team": "blue", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "chopper", "x": -1, "y": 37, "team": "blue", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "wraith", "x": -1, "y": 38, "team": "blue", "orders": { "type": "hunt" } });
                        game.add({ "type": "aircraft", "name": "chopper", "x": -1, "y": 39, "team": "blue", "orders": { "type": "hunt" } });
                    }
                },
                {
                    "type": "timed", "time": 660000,
                    // Dodajemy minutę po dotarciu posiłków i kończymy poziom
                    "action": function() {
                        singleplayer.endLevel(true);
                    }
                },
            ],
        }
    ],

    "multiplayer": [

    ]
};
