var mouse = {
    init: function() {
        // Oczekujemy na zdarzenia myszy przechwytywane przez obiekt canvas znajdujący się na pierwszym planie
        let canvas = document.getElementById("gameforegroundcanvas");

        canvas.addEventListener("mousemove", mouse.mousemovehandler, false);

        canvas.addEventListener("mouseenter", mouse.mouseenterhandler, false);
        canvas.addEventListener("mouseout", mouse.mouseouthandler, false);

        canvas.addEventListener("mousedown", mouse.mousedownhandler, false);
        canvas.addEventListener("mouseup", mouse.mouseuphandler, false);

        mouse.canvas = canvas;
    },

    // współrzędne x,y myszy względem górnego lewego rogu obiektu canvas
    x: 0,
    y: 0,

    // współrzędne x,y względem górnego lewego rogu mapy gry
    gameX: 0,
    gameY: 0,

    // współrzędne x,y myszy na siatce gry
    gridX: 0,
    gridY: 0,

    calculateGameCoordinates: function() {
        mouse.gameX = mouse.x + game.offsetX ;
        mouse.gameY = mouse.y + game.offsetY;

        mouse.gridX = Math.floor((mouse.gameX) / game.gridSize);
        mouse.gridY = Math.floor((mouse.gameY) / game.gridSize);
    },

    setCoordinates: function(clientX, clientY) {
        let offset = mouse.canvas.getBoundingClientRect();

        mouse.x = (clientX - offset.left) / game.scale;
        mouse.y = (clientY - offset.top) / game.scale;

        mouse.calculateGameCoordinates();
    },

    // sprawdzamy, czy kursor myszy znajduje w obrębie obiektu canvas
    insideCanvas: false,

    mousemovehandler: function(ev) {
        mouse.insideCanvas = true;

        mouse.setCoordinates(ev.clientX, ev.clientY);
        mouse.checkIfDragging();
    },

    // Czy gracz przeciąga i zaznacza po naciśnięciu lewego przycisku myszy
    dragSelect: false,
    // Jeśli mysz zostanie przeciągnięta o większą odległość, zakładamy, że gracz próbuje coś zaznaczyć
    dragSelectThreshold: 5,

    checkIfDragging: function() {
        if (mouse.buttonPressed) {
            // Jeśli mysz zostanie przeciągnięta o więcej niż wartość graniczna, traktujemy to jako przeciągnięcie 
            if ((Math.abs(mouse.dragX - mouse.gameX) > mouse.dragSelectThreshold && Math.abs(mouse.dragY - mouse.gameY) > mouse.dragSelectThreshold)) {
                mouse.dragSelect = true;
            }
        } else {
            mouse.dragSelect = false;
        }
    },

    mouseenterhandler: function() {
        mouse.insideCanvas = true;
    },

    mouseouthandler: function() {
        mouse.insideCanvas = false;
    },

    // Czy jest naciśnięty lewy przycisk myszy 
    buttonPressed: false,

    mousedownhandler: function(ev) {
        mouse.insideCanvas = true;
        mouse.setCoordinates(ev.clientX, ev.clientY);

        if (ev.button === 0) { // Lewy przycisk myszy został naciśnięty 
            mouse.buttonPressed = true;

            mouse.dragX = mouse.gameX;
            mouse.dragY = mouse.gameY;

            // ev.preventDefault();
        }
    },

    // Metoda wywoływana, gdy gracz kliknie obszar canvas lewym przyciskiem myszy 
    leftClick: function(shiftPressed) {
        let clickedItem = mouse.itemUnderMouse();

        if (clickedItem) {
            // Naciśnięcie klawisza Shift doda obiekt do istniejącego zaznaczenia. Jeśli klawisz ten nie jest naciśnięty, czyścimy bieżące zaznaczenie 
            if (!shiftPressed) {
                game.clearSelection();
            }

            game.selectItem(clickedItem, shiftPressed);
        }
    },

    // Zwracamy pierwszy wykryty obiekt znajdujący się poniżej kursora myszy.
    itemUnderMouse: function() {
        for (let i = game.items.length - 1; i >= 0; i--) {
            let item = game.items[i];

            // Elementy oznaczone flagą dead zostaną pominięte 
            if (item.lifeCode === "dead") {
                continue;
            }

            let x = item.x * game.gridSize;
            let y = item.y * game.gridSize;

            if (item.type === "buildings" || item.type === "terrain") {
                // Jeśli współrzędne kursora myszy znajdują się w prostokątnych granicach budynku lub terenu
                if (x <= mouse.gameX && x >= (mouse.gameX - item.baseWidth) && y <= mouse.gameY && y >= (mouse.gameY - item.baseHeight)) {
                    return item;
                }
            } else if (item.type === "aircraft") {
                    // Jeśli współrzędne kursora myszy znajdują się w promieniu statku powietrznego (po uwzględnienia wartości pixelShadowHeight)
                if (Math.pow(x - mouse.gameX, 2) + Math.pow(y - mouse.gameY - item.pixelShadowHeight, 2) < Math.pow(item.radius, 2)) {
                    return item;
                }
            } else if (item.type === "vehicles") {
                    // Jeśli współrzędne kursora myszy znajdują się w promieniu elementu 
                if (Math.pow(x - mouse.gameX, 2) + Math.pow(y - mouse.gameY, 2) < Math.pow(item.radius, 2)) {
                    return item;
                }
            }
        }
    },

    mouseuphandler: function(ev) {
        mouse.setCoordinates(ev.clientX, ev.clientY);

        let shiftPressed = ev.shiftKey;

        if (ev.button === 0) { // Lewy przycisk myszy został zwolniony 
            if (mouse.dragSelect) {
                // Jeśli obecnie przeciągamy w celu zaznaczenia, próbujemy zaznaczyć elementy znajdujące się wewnątrz ramki zaznaczenia 
                mouse.finishDragSelection(shiftPressed);
            } else {
                // Jeśli nie przeciągamy, traktujemy to jako normalne kliknięcie po zwolnieniu myszy
                mouse.leftClick(shiftPressed);
            }

            mouse.buttonPressed = false;

            // ev.preventDefault();
        }
    },

    finishDragSelection: function(shiftPressed) {
        if (!shiftPressed) {
            // Jeśli nie jest naciśnięty klawisz Shift, usuwamy zaznaczenie elementów  
            game.clearSelection();
        }

        // Obliczamy współrzędne obwiedni prostokąta zaznaczenia 
        let x1 = Math.min(mouse.gameX, mouse.dragX);
        let y1 = Math.min(mouse.gameY, mouse.dragY);
        let x2 = Math.max(mouse.gameX, mouse.dragX);
        let y2 = Math.max(mouse.gameY, mouse.dragY);

        game.items.forEach(function(item) {
            // Elementy, których nie można zaznaczyć, elementy oznaczone flagą dead, elementy należące do przeciwnika oraz budynki nie podlegają zaznaczeniu za pomocą przeciągnięcia 
            if (!item.selectable || item.lifeCode === "dead" || item.team !== game.team || item.type === "buildings") {
                return;
            }

            let x = item.x * game.gridSize;
            let y = item.y * game.gridSize;

            if (x1 <= x && x2 >= x) {
                if ((item.type === "vehicles" && y1 <= y && y2 >= y)
                    // W przypadku statku powietrznego uwzględniamy wartość pixelShadowHeight
                    || (item.type === "aircraft" && (y1 <= y - item.pixelShadowHeight) && (y2 >= y - item.pixelShadowHeight))) {

                    game.selectItem(item, shiftPressed);
                }
            }
        });

        mouse.dragSelect = false;
    },

    draw: function() {
        // Jeśli gracz przeciąga zaznaczenie, rysujemy biały prostokąt oznaczający zaznaczany obszar
        if (this.dragSelect) {
            let x = Math.min(this.gameX, this.dragX);
            let y = Math.min(this.gameY, this.dragY);

            let width = Math.abs(this.gameX - this.dragX);
            let height = Math.abs(this.gameY - this.dragY);

            game.foregroundContext.strokeStyle = "white";
            game.foregroundContext.strokeRect(x - game.offsetX, y - game.offsetY, width, height);
        }
    },
};