var mouse = {
    init: function() {
        // Oczekujemy na zdarzenia myszy przechwytywane przez obiekt canvas znajdujący się na pierwszym planie
        let canvas = document.getElementById("gameforegroundcanvas");

        canvas.addEventListener("mousemove", mouse.mousemovehandler, false);

        canvas.addEventListener("mouseenter", mouse.mouseenterhandler, false);
        canvas.addEventListener("mouseout", mouse.mouseouthandler, false);

        mouse.canvas = canvas;
    },

    // współrzędne x,y myszy względem górnego lewego rogu obiektu canvas
    x: 0,
    y: 0,

    // współrzędne x,y względem górnego lewego rogu mapy gry
    gameX: 0,
    gameY: 0,

    // współrzędne x,y myszy na siatce gry 
    gridX: 0,
    gridY: 0,

    calculateGameCoordinates: function() {
        mouse.gameX = mouse.x + game.offsetX ;
        mouse.gameY = mouse.y + game.offsetY;

        mouse.gridX = Math.floor((mouse.gameX) / game.gridSize);
        mouse.gridY = Math.floor((mouse.gameY) / game.gridSize);
    },

    setCoordinates: function(clientX, clientY) {
        let offset = mouse.canvas.getBoundingClientRect();

        mouse.x = (clientX - offset.left) / game.scale;
        mouse.y = (clientY - offset.top) / game.scale;

        mouse.calculateGameCoordinates();
    },

    // sprawdzamy, czy kursor myszy znajduje w obrębie obiektu canvas
    insideCanvas: false,

    mousemovehandler: function(ev) {
        mouse.insideCanvas = true;
        mouse.setCoordinates(ev.clientX, ev.clientY);
    },

    mouseenterhandler: function() {
        mouse.insideCanvas = true;
    },

    mouseouthandler: function() {
        mouse.insideCanvas = false;
    },
};