<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
define("LOGIN_OK", 1);
define("LOGIN_FAILED", 2);
define("SERVER_ERROR", 3);
 
class Site
{
  private $dbo = null;
  function initDB($host, $user, $pass, $db)
  {
    $this->dbo = new SQLiteDatabase("/var/www/db/users.sqlite");
    
    if(!$this->dbo){
      $msg = "Brak połączenia z bazą danych: ";
      throw new Exception($msg);
    }
  }
  function login()
  {
    unset($_SESSION['zalogowany']);
    
    if(!$this->dbo){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["pass"])){
      $this->setMessage('Nieprawidłowe dane.');
      return LOGIN_FAILED;
    }
    
    $user = $_POST["user"];
    $pass = $_POST["pass"];
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT Haslo, Nazwa, Id ";
    $query .= "FROM Users WHERE Nazwa='$user'";

    if(!$result = $this->db->query($query)){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie wyników zapytania.
    if($this->db->num_rows($result) == 1){
      $row = $this->db->fetch_row($result);
      if($row && $row[0] == $pass){
        $this->setMessage("Jesteś zalogowany jako {$row[1]}.");
        $_SESSION['zalogowany'] = $row[1];
        return LOGIN_OK;
      }
      else{
        $this->setMessage('Nieprawidłowa nazwa lub hasło.');
        return LOGIN_FAILED;
      }
    }
    else{
      $this->setMessage('Nieprawidłowa nazwa lub hasło.');
      return LOGIN_FAILED;
    }
  }
  function logout()
  {
    unset($_SESSION['zalogowany']);
    header('Location:index.php');
  }
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function deleteMessage()
  {
    if(isset($_SESSION['message'])){
      unset($_SESSION['message']);
    }
  }
  function showMain()
  {
    if(isset($_SESSION['zalogowany'])){
      include 'tmpl/main.tpl';
    }
    else{
      include 'tmpl/form.tpl';
    }
  }
}

?>