<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $imagespath = 'images/';
  private $thumbnailspath = 'thumbnails/';
  private $descriptionspath = 'descriptions/';
  
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function getMessage()
  {
    if(isset($_SESSION['message'])){
      $message = $_SESSION['message'];
      unset($_SESSION['message']);
      return $message;
    }
    return false;
  }
  function getThumbnailsList()
  {
    $files = array();
    if($dir = scandir($this->thumbnailspath)){
      foreach($dir as $file){
        if(is_file($this->thumbnailspath.$file) && 
           strtolower(substr($file, -4)) == '.jpg'){
          $files[] = substr($file, 0, -4);
        }
      }
    }
    return $files;
  }
  function showImage()
  {
    if(!isset($_REQUEST['name'])){
      $this->setMessage('Nieprawidłowe wywołanie.');
      return ACTION_FAILED;
    }
    
    $image = $_REQUEST['name'] . '.jpg';
    $description_file = $_REQUEST['name'] . '.txt';
    
    if(!$description = file_get_contents($this->descriptionspath.$description_file)){
      $description = 'Brak opisu';
    }
    
    $message = $this->getMessage();
    $imagespath = $this->imagespath;
    
    include 'tmpl/image.tpl.php';
  }
  function showMain()
  {
    $message = $this->getMessage();
    $images = $this->getThumbnailsList();
    $thumbnailspath = $this->thumbnailspath;

    include 'tmpl/main.tpl.php';
  }
}

?>