<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $dbo = null;
  private $maxBadLoginCount = 3;
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
      //Wyłącznie emulacji zaptyań parametryzowanych
      //$this->dbo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function deleteMessage()
  {
    if(isset($_SESSION['message'])){
      unset($_SESSION['message']);
    }
  }
  function getPostsFromExternalSource($user, $count)
  {
    $params = "user=$user&count=$count";
    $curl = curl_init("http://localhost/zew_serwis/api.php?$params");
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $data = curl_exec($curl);
    curl_close($curl);
    $data = json_decode($data, true);
    
    if($data['status'] > 0 && count($data['dane'])){
      return $data['dane'];
    }
    return array();
  }
  function showMain()
  {
    $postsdata = $this->getPostsFromExternalSource('MojSerwis@TwojeStatusy', 5);
    include 'tmpl/main.tpl.php';
  }
}

?>