<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
define("ACTION_OK", 1);
define("ACTION_FAILED", 2);
define("SERVER_ERROR", 3);
 
class Site
{
  private $dbo = null;
  private $maxBadLoginCount = 3;
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  function login()
  {
    unset($_SESSION['zalogowany']);
    
    if(!$this->dbo){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["pass"])){
      $this->setMessage('Nieprawidłowe dane.');
      return ACTION_FAILED;
    }
    
    $user = $this->dbo->quote($_POST["user"]);
    $pass = $_POST["pass"];
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query  = "SELECT * FROM Users WHERE Nazwa=$user";

    if(!$result = $this->dbo->query($query)){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie wyników zapytania.
    if(($rows = $result->fetchAll()) && count($rows) == 1){
      $row = $rows[0];
      
      if(isset($_SESSION['activeCaptcha']) && $_SESSION['activeCaptcha']){
        //Za duża liczba błędnych logowań
        if(!isset($_POST["recaptcha_challenge_field"]) || 
           !isset($_POST["recaptcha_response_field"])){
          $this->setMessage("Podaj prawidłowy kod z obrazka.");
          return ACTION_FAILED;
        }
        require_once('recaptchalib.php');
        $resp = recaptcha_check_answer("klucz_prywatny",
          $_SERVER["REMOTE_ADDR"], $_POST["recaptcha_challenge_field"],
          $_POST["recaptcha_response_field"]);
        if (!$resp->is_valid) {
          $this->setMessage("Podaj prawidłowy kod z obrazka." . $resp->error);
          return ACTION_FAILED;
        }
      }
      if($row && $row['Haslo'] == crypt($pass, $row['Haslo'])){
        //Hasło jest prawidłowe
        $this->setMessage("Jesteś zalogowany jako {$row['Nazwa']}.");
        $_SESSION['zalogowany'] = $row['Nazwa'];
        
        //Usunięcie wymagania captcha
        if(isset($_SESSION['activeCaptcha']))
          unset($_SESSION['activeCaptcha']);
        
        //Usunięcie licznika błędnych logowań
        if($row['ZleLogowania']){
          $query  = "UPDATE Users SET ZleLogowania = 0 "; 
          $query .= "WHERE Id = {$row['Id']}";
          if(!$this->dbo->exec($query)){
            //Błąd przy aktualizacji danych
          }
        }
        return ACTION_OK;
      }
      else{
        //Hasło jest nieprawidłowe
        if($row['ZleLogowania'] >= $this->maxBadLoginCount - 1){
          $_SESSION['activeCaptcha'] = true;
        }
        //Uaktualnienie liczby błędnych prób logowania
        $query  = "UPDATE Users SET ZleLogowania = ZleLogowania + 1 ";
        $query .= "WHERE id = {$row['Id']}";

        if(!$this->dbo->exec($query)){
          //Błąd przy aktualizacji danych
        }
        $this->setMessage('Nieprawidłowa nazwa lub hasło.');
        return ACTION_FAILED;
      }
    }
    else{
      $this->setMessage('Nieprawidłowa nazwa lub hasło.');
      return ACTION_FAILED;
    }
  }
  function logout()
  {
    unset($_SESSION['zalogowany']);
    header('Location:index.php');
  }
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function deleteMessage()
  {
    if(isset($_SESSION['message'])){
      unset($_SESSION['message']);
    }
  }
  function showMain()
  {
    if(isset($_SESSION['zalogowany'])){
      include 'tmpl/main.tpl';
    }
    else{
      $formMsg = 'Musisz się zalogować:';
      $btnMsg = 'Zaloguj';
      $formAction = 'index.php?action=login';
      include 'tmpl/form.tpl';
    }
  }
}

?>