<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $dbo = null;
  
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
      //Wyłącznie emulacji zapytań parametryzowanych
      //$this->dbo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  
  function setMessage($msg)
  {
    setcookie('message', $msg);
  }
  function getMessage()
  {
    if(isset($_COOKIE['message'])){
      $message = $_COOKIE['message'];
      setcookie('message', '');
      return $message;
    }
    return false;
  }
  
  function getItems()
  {
    if(!$this->dbo){
      $this->setMessage("Błąd serwera. Nie można wyświetlić towarów.");
      return array();
    }
    
    //Wykonanie zapytania pobierającego dane
    $query = "SELECT Id, Cena, Nazwa, 1 AS Sztuk FROM Towary ORDER BY Nazwa";

    if(!($result = $this->dbo->query($query)) || 
       !($rows = $result->fetchAll())){
      $this->setMessage("Nie ma towarów do wyświetlenia.");
      return array();
    }
    return $rows;
  }
  
  function getBasketItems()
  {
    if(isset($_COOKIE['basket'])){
      return  unserialize($_COOKIE['basket']);
    }
    else{
      return array();
    }
  }
  
  function saveorder()
  {
    if(isset($_REQUEST['adres']) && ($adres = $_REQUEST['adres']) != ''){
      if(isset($_COOKIE['basket'])){
        //Deserializajca danych z cookie
        $basket = unserialize($_COOKIE['basket']);
        
        //Formowanie zapytania dodającego zamówienie
        $adres = $this->dbo->quote($adres);
        $query = "INSERT INTO zamowienia VALUES (0, NOW(), 1, $adres)";
        
        //Wykonanie zapytania dodajacego zamówienie
        if(!$this->dbo->query($query)){
          $this->setMessage("
            Wystąpił błąd. Zamówienie nie zostało dodane.");
          return ACTION_FAILED;
        }
        
        //Sprawdzenie wyników zapytania.
        
        if(!$idZamowienia = $this->dbo->lastInsertId()){
          $this->setMessage(
            "Wystąpił błąd. Zamówienie nie zostało dodane.");
          return ACTION_FAILED;
        }
        
        //Zapisanie szczegółów zamówienia
        foreach($basket as $item){
          $id = $item['Id'];
          $cena = $item['Cena'];
          $sztuk = $item['Sztuk'];
          
          $query = "INSERT INTO towaryzamowienia " . 
                   "VALUES ($idZamowienia, $id, $sztuk, $cena)";
          $this->dbo->query($query);
        }
        
        //Komuniakt z nr zamówienia i wyzerowanie koszyka
        $this->setMessage(
            "Zamówienie zostało dodane. Identyfikator = $idZamowienia.");
        
        setcookie('basket', '');
      }
      else{
        $this->setMessage('Brak produktów w koszyku.');
      }
    }
    else{
      $this->setMessage('Nalezy podać adres dla zamówienia.');
    }
  }
    
  function addtobasket()
  {
    if(!isset($_COOKIE['basket'])){
      $basket = array();
    }
    else{
      $basket = unserialize($_COOKIE['basket']);
    }
    
    if(isset($_REQUEST['itemid']) && isset($_REQUEST['sztuk']) && 
       isset($_REQUEST['nazwa']) && isset($_REQUEST['cena'])){
      $sztuk = intval($_REQUEST['sztuk']);
      $itemid = intval($_REQUEST['itemid']);
      $nazwa = $_REQUEST['nazwa'];
      $cena = $_REQUEST['cena'];
      
      if($sztuk > 0){
        $basket[$itemid] = array('Id' => $itemid, 
                                 'Nazwa' => $nazwa, 
                                 'Cena' => $cena,
                                 'Sztuk' => $sztuk);
      }
      else{
        if(isset($basket[$itemid])){
          unset($basket[$itemid]);
        }
        else{
          $this->setMessage('Liczba sztuk musi być większa od 0.');
          return;
        }
      }
      setcookie('basket', serialize($basket));
      $this->setMessage('Koszyk został modyfikowany.');
    }
    else{
      $this->setMessage('Musisz wybrać produkt i podać liczbę sztuk.');
    }
  }
  
  function showbasket()
  {
    $message = $this->getMessage();
    $towary = $this->getBasketItems();
    $display = 'basket';
    include 'tmpl/main.tpl.php';
  }
  
  function showMain()
  {
    $message = $this->getMessage();
    $towary = $this->getItems();
    $display = 'main';
    include 'tmpl/main.tpl.php';
  }
}

?>