<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $dbo = null;
  private $uploadDir = './imgs/';
  
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
      //Wyłącznie emulacji zapytań parametryzowanych
      //$this->dbo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function getMessage()
  {
    if(isset($_SESSION['message'])){
      $message = $_SESSION['message'];
      unset($_SESSION['message']);
      return $message;
    }
    return false;
  }
  
  function fileUpload()
  {
    if(!isset($_FILES['file']) || !isset($_REQUEST['desc'])){
      $this->setMessage('Proszę używać fomularza ze strony.');
    }
    else if($_FILES['file']['error'] == UPLOAD_ERR_OK){
    
      $tmp_name = $_FILES['file']['tmp_name'];
      $org_name = $_FILES['file']['name'];
      $type = $_FILES['file']['type'];
      $name = $this->uploadDir.$org_name;
      
      if($type != 'image/jpeg' && $type != 'image/gif' && $type != 'image/png'){
        $this->setMessage('Akceptujemy tylko pliki typów JPEG, GIF i PNG.');
      }
      else if(move_uploaded_file($tmp_name, $name)){
        $desc = $this->dbo->quote($_REQUEST['desc']);
        
        $query = "INSERT INTO images (nazwa, opis, czas) VALUES('$name', $desc, CURRENT_TIMESTAMP)";
        
        if(!$this->dbo->query($query)){
          $this->setMessage('Wystąpił błąd. Plik nie został załadowany.');
        }
        else{
          $this->setMessage('Plik został załadowany.');
        }
      }
      else{
        $this->setMessage('Wystąpił błąd. Plik nie został załadowany.');
      }
    }
    else{
      $this->setMessage('Wystąpił błąd. Plik nie został załadowany.');
    }
  }
  
  function getFilesList()
  {
    $query = "SELECT * FROM images ORDER BY czas DESC LIMIT 5";

    if($result = $this->dbo->query($query)){
      if($rows = $result->fetchAll(PDO::FETCH_ASSOC)){
        return $rows;
      }
      else{
        return array();
      }
    }
    else{
      return array();
    }
  }
  
  function showUploadForm()
  {
    $message = $this->getMessage();
    include 'tmpl/upload.tpl.php';
  }
  
  function showMain()
  {
    $message = $this->getMessage();
    $images = $this->getFilesList();
    include 'tmpl/main.tpl.php';
  }
}

?>