<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $dbo = null;
  private $maxBadLoginCount = 3;
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
      //Wyłącznie emulacji zaptyań parametryzowanych
      //$this->dbo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function getMessage()
  {
    if(isset($_SESSION['message'])){
      $message = $_SESSION['message'];
      unset($_SESSION['message']);
      return $message;
    }
    return false;
  }
  function login()
  {
    unset($_SESSION['zalogowany']);
    
    if(!$this->dbo){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["pass"])){
      $this->setMessage('Nieprawidłowe dane.');
      return ACTION_FAILED;
    }
    
    $user = $this->dbo->quote($_POST["user"]);
    $pass = $_POST["pass"];
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT Id, Nazwa, Haslo FROM Users WHERE Nazwa=$user";

    if(!$result = $this->dbo->query($query)){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie wyników zapytania.
    if($result->rowCount() == 1){
      $row = $result->fetch();
      //if($row && $row['Haslo'] == crypt($pass, $row['Haslo'])){
      //hasła niekodowane dla łatwiejszej manipulacji danymi w bazie
      if($row && $row['Haslo'] == $pass){
        //Hasło jest prawidłowe
        $this->setMessage("Jesteś zalogowany jako {$row['Nazwa']}.");
        $_SESSION['zalogowany'] = $row;
        return ACTION_OK;
      }
      else{
        //Hasło jest nieprawidłowe
        $this->setMessage('Nieprawidłowa nazwa lub hasło.'.$blokStr);
        return ACTION_FAILED;
      }
    }
    else{
      $this->setMessage('Nieprawidłowa nazwa lub hasło.');
      return ACTION_FAILED;
    }
  }
  
  function logout()
  {
    unset($_SESSION['zalogowany']);
  }
  function transfer()
  {
    //sprawdzenie czy użytkownik jest zalogowany
    if(!isset($_SESSION['zalogowany'])){
      $this->setMessage('Najpierw musisz się zalogować.');
      return ACTION_FAILED;
    }
   
    //sprawdzenie czy zostały przekazane parametry
    if(!isset($_REQUEST['userid']) || !isset($_REQUEST['points'])){
      $this->setMessage('Błędne dane.');
      return ACTION_FAILED;
    }
    
    //konwersja danych do typu int
    $userid = intval($_REQUEST['userid']);
    $points = intval($_REQUEST['points']);
    
    //sprawdzenie poprawności parametrów
    if($userid < 1 || $points < 0){
      $this->setMessage('Błędne dane.');
      return ACTION_FAILED;
    }
    
    //rozpoczęcie transakcji
    $this->dbo->beginTransaction();
    
    //wykonanie instrukcji skłądajacych się na transfer punktów
    $query1 = "UPDATE users SET stan_konta = stan_konta - $points "
            . "WHERE id = {$_SESSION['zalogowany']['Id']}";
           
    if(!$this->dbo->query($query1)){
      $this->setMessage('Błąd serwera. Transfer nie został wykonany.');
      //$this->dbo->rollback();
      return ACTION_FAILED;
    }
    
    $query2 = "UPDATE users SET stan_konta = stan_konta + $points "
            . "WHERE id = $userid";
    
    if(!$this->dbo->query($query2)){
      $this->setMessage('Błąd serwera. Transfer nie został wykonany.');
      //$this->dbo->rollback();
      return ACTION_FAILED;
    }
    
    //zatwierdzenie transakcji
    $this->dbo->commit();
    
    $this->setMessage('Transfer został wykonany.');
    return ACTION_OK;
  }
  function getAccountBalance($id)
  {
    $query = "SELECT stan_konta FROM Users WHERE id=$id";//brak weryfikacji poprawności argumentu

    if(!($result = $this->dbo->query($query)) || !($row = $result->fetch())){
      return false;
    }
    return $row[0];
  }
  function showTransfer()
  {
    $query = "SELECT id, nazwa FROM Users WHERE id != {$_SESSION['zalogowany']['Id']}";

    if(!($result = $this->dbo->query($query)) || !($users  = $result->fetchAll())){
      $users = array();
    }
    
    $message = $this->getMessage();
    $stan_konta = $this->getAccountBalance($_SESSION['zalogowany']['Id']);
    $user = $_SESSION['zalogowany']['Nazwa'];
    
    include 'tmpl/transfer.tpl.php';
  }
  
  function showMain()
  {
    $message = $this->getMessage();
    if(isset($_SESSION['zalogowany'])){
      $stan_konta = $this->getAccountBalance($_SESSION['zalogowany']['Id']);
      $user = $_SESSION['zalogowany']['Nazwa'];
    }
    include 'tmpl/main.tpl.php';
  }
}

?>