<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
define("ACTION_OK", 1);
define("ACTION_FAILED", 2);
define("SERVER_ERROR", 3);
 
class Site
{
  private $dbo = null;
  private $maxBadLoginCount = 3;
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host", $user, $pass);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  function login()
  {
    unset($_SESSION['zalogowany']);
    
    if(!$this->dbo){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["pass"])){
      $this->setMessage('Nieprawidłowe dane.');
      return ACTION_FAILED;
    }
    
    $user = $this->dbo->quote($_POST["user"]);
    $pass = $_POST["pass"];
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT * FROM Users WHERE Nazwa=$user";

    if(!$result = $this->dbo->query($query)){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie wyników zapytania.
    if($result->rowCount() == 1){
      $row = $result->fetch();
      if($row['Zablokowane']){
        //Konto jest zablokowane
        $this->setMessage('To konto jest zablokowane.');
        return ACTION_FAILED;
      }
      if($row && $row['Haslo'] == crypt($pass, $row['Haslo'])){
        //Hasło jest prawidłowe
        $this->setMessage("Jesteś zalogowany jako {$row['Nazwa']}.");
        $_SESSION['zalogowany'] = $row['Nazwa'];
        
        //Usunięcie licznika błędnych logowań
        if($row['ZleLogowania']){
          $query = "UPDATE Users SET ZleLogowania = 0 WHERE Id = {$row['Id']}";
          if(!$this->dbo->exec($query)){
            //Błąd przy aktualizacji danych
          }
        }
        return ACTION_OK;
      }
      else{
        //Hasło jest nieprawidłowe
        $blokStr = '';
        if($row['ZleLogowania'] >= $this->maxBadLoginCount - 1){
          //Przekroczona liczba prób logowania, zablokowanie konta
          $query  = "UPDATE Users SET Zablokowane = 1, ";
          $query .= "ZleLogowania = ZleLogowania + 1 ";
          $query .= "WHERE id = {$row['Id']}";
          $blokStr = ' Konto zostało zablokowane.';
        }
        else{
          //Uaktualnienie liczby błędnych prób logowania
          $query  = "UPDATE Users SET ZleLogowania = ZleLogowania + 1";
          $query .= " WHERE id = {$row['Id']}";
          $blokStr = ' Liczba pozostałych prób: ' . 
                     ($this->maxBadLoginCount - $row['ZleLogowania'] - 1);
        }
        if(!$this->dbo->exec($query)){
          //Błąd przy aktualizacji danych
        }
        $this->setMessage('Nieprawidłowa nazwa lub hasło.'.$blokStr);
        return ACTION_FAILED;
      }
    }
    else{
      $this->setMessage('Nieprawidłowa nazwa lub hasło.');
      return ACTION_FAILED;
    }
  }
  
  function logout()
  {
    unset($_SESSION['zalogowany']);
    header('Location:index.php');
  }
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function deleteMessage()
  {
    if(isset($_SESSION['message'])){
      unset($_SESSION['message']);
    }
  }
  function showMain()
  {
    if(isset($_SESSION['zalogowany'])){
      include 'tmpl/main.tpl';
    }
    else{
      $formMsg = 'Musisz się zalogować:';
      $btnMsg = 'Zaloguj';
      $formAction = 'index.php?action=login';
      include 'tmpl/form.tpl';
    }
  }
}

?>