<?php
// tworzymy kilka wasnych wyjtkw, ktre mona bdzie przechwyci
// w razie potrzeby

// oglny wyjtek wyszukiwarki tekstw piosenek
class LyricsFinderException extends CException {}

// uywany, gdy wystpi problem z poczeniem
class LyricsFinderHTTPException extends LyricsFinderException{}
class LyricsFinder
{
   private $apiUrl = 'http://example.com/lyricsapi&songtitle=%s';
   function getText($songTitle)
   {
      $url = $this->getRequestUrl($songTitle);
      $curl = curl_init();       
      curl_setopt($curl, CURLOPT_URL, $url); 
      curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
      $result = curl_exec($curl);

      // jeli pojawi si bd HTTP, rzucamy wyjtek 
      if($result===false)
      {
         $errorText = curl_error($curl);
         curl_close($url);
         throw new LyricsFinderHTTPException($errorText);
      }
      curl_close($curl);
      return $result;
   }
   private function getRequestUrl($songTitle)
   {
      return sprintf($this->apiUrl, urlencode($songTitle));
   }
}

