﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.ApplicationModel.Activation;
using Windows.ApplicationModel.Search;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.ViewManagement;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

// The Search Contract item template is documented at http://go.microsoft.com/fwlink/?LinkId=234240

namespace MojeSpotkania
{
    /// <summary> 
    /// This page displays search results when a global search is directed to this application.
    /// </summary>
    public sealed partial class WynikiWyszukiwania : MojeSpotkania.Common.LayoutAwarePage
    {

        List<Spotkanie> elementy = new List<Spotkanie>();
        string searchString;
        SearchPane searchPane; 

 
        public WynikiWyszukiwania()
        {
            this.InitializeComponent();            
            searchPane = SearchPane.GetForCurrentView();
        }

        /// <summary>
        /// Populates the page with content passed during navigation.  Any saved state is also
        /// provided when recreating a page from a prior session.
        /// </summary>
        /// <param name="navigationParameter">The parameter value passed to
        /// <see cref="Frame.Navigate(Type, Object)"/> when this page was initially requested.
        /// </param>
        /// <param name="pageState">A dictionary of state preserved by this page during an earlier
        /// session.  This will be null the first time a page is visited.</param>
        protected override async void LoadState(Object navigationParameter, Dictionary<String, Object> pageState)
        {      
            searchString = (navigationParameter as String).ToLower();

            resultText.Text = searchString;
            elementy = await OperacjeBazy.ZnajdzSpotkanie(searchString.ToLower());

            this.DefaultViewModel["QueryText"] = '\u201c' + searchString + '\u201d';
            resultsViewSource.Source = elementy;
        }

        private void resultsGridView_Tapped(object sender, TappedRoutedEventArgs e)
        {
            Spotkanie elementSpotkania = (Spotkanie)resultsGridView.SelectedItem;
            if (elementSpotkania.ID != -1)
                this.Frame.Navigate(typeof(SpotkaniaStrona), elementSpotkania.ID);
        }
    }
}