﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

// The User Control item template is documented at http://go.microsoft.com/fwlink/?LinkId=234236

namespace MojeSpotkania
{
    public sealed partial class DateTimePicker : UserControl
    {
        private bool initializing = true;

        private int InputCounter = 1;
        private string VisibleDate = "";
        private bool wasOffseted = false;


        public DateTimePicker()
        {
            InitializeComponent();

            initializing = false;

            dtPanel.Transitions = new Windows.UI.Xaml.Media.Animation.TransitionCollection();
            dtPanel.Transitions.Add(new Windows.UI.Xaml.Media.Animation.PopupThemeTransition());                            
        }

        public static readonly DependencyProperty AllowNullProperty =
            DependencyProperty.Register("AllowNull", typeof(bool), typeof(DateTimePicker), new PropertyMetadata(true));

        public bool AllowNull
        {
            get { return (bool)GetValue(AllowNullProperty); }
            set { SetValue(AllowNullProperty, value); }
        }

        public static readonly DependencyProperty SelectedDateProperty =
            DependencyProperty.Register("SelectedDate", typeof(DateTime?), typeof(DateTimePicker), new PropertyMetadata(null, OnSelectedItemChanged));

        private DateTime? selectedDate;

        /// <summary>
        /// Pole, które przygotowuje datę do wyświetlenia
        /// </summary>
        public DateTime? SelectedDate
        {
            get { return selectedDate; }
            set 
            {
                string dataDoPokazania = value.Value.Day + "." + value.Value.Month + "." + value.Value.Year + " " + value.Value.Hour + ":" + value.Value.Minute;
                if (dataDoPokazania == "1.1.1 0:0")
                {
                    txtSelectedDate.Text = "Wybierz datę";
                    txtSelectedDate.Foreground = new SolidColorBrush(Colors.SkyBlue);
                }
                else
                {
                    txtSelectedDate.Text = dataDoPokazania;
                    txtSelectedDate.Foreground = new SolidColorBrush(Colors.White);
                }

                selectedDate = value;
            }
        }

        public event RoutedEventHandler SelectedItemChanged;

        private static void OnSelectedItemChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            var ctrl = (DateTimePicker)d;
            if (ctrl.initializing)
                return;

            ctrl.initializing = true;

            ctrl.initializing = false;

            if (ctrl.SelectedItemChanged != null)
                ctrl.SelectedItemChanged(ctrl, new RoutedEventArgs());
        }

        /// <summary>
        /// Zdarzenie wywoływane przy kliknięciu w pole wyboru daty. Pojawia się PopUp wpisywania daty
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void TextBlock_Tapped_1(object sender, TappedRoutedEventArgs e)
        {
            if (!wasOffseted)
            {
                double offset = dtKeyboard.VerticalOffset;
                dtKeyboard.VerticalOffset = offset + 50;
                wasOffseted = true;
            }

            InputCounter = 1;
            dtKeyboard.IsOpen = true;

            txtSelectedDate.Text = "_ _._ _._ _ _ _  _ _:_ _";

        }

        /// <summary>
        /// Uniwersalne zdarzenie wywoływane po wciśnięciu dowolnego przycisku
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Button_Tapped_1(object sender, TappedRoutedEventArgs e)
        {
            Button button = (Button)sender;
            SetDateText(button.Content.ToString());
        }

        /// <summary>
        /// Kontrola wpisanej liczby - w zależności od tego, która z kolei liczba została wpisana, zmienia się zachowanie kontrolki
        /// </summary>
        /// <param name="entered"></param>
        private void SetDateText(string entered)
        {
            switch (InputCounter)
            {
                case 1:
                    VisibleDate = entered;
                    txtSelectedDate.Text = VisibleDate + "_._ _._ _ _ _  _ _:_ _";
                    break;
                case 2:
                    VisibleDate += entered;
                    txtSelectedDate.Text = VisibleDate + "._ _._ _ _ _  _ _:_ _";
                    txtGuide.Text = "Podaj miesiąc";
                    break;
                case 3:
                    VisibleDate += ".";
                    VisibleDate += entered;
                    txtSelectedDate.Text = VisibleDate + "_._ _ _ _  _ _:_ _";
                    break;
                case 4:
                    VisibleDate += "";
                    VisibleDate += entered;
                    txtSelectedDate.Text = VisibleDate + "._ _ _ _  _ _:_ _";
                    txtGuide.Text = "Podaj rok";
                    break;
                case 5:
                    VisibleDate += ".";
                    VisibleDate += entered;
                    txtSelectedDate.Text = VisibleDate + "_ _ _  _ _:_ _";
                    break;
                case 6:
                    VisibleDate += "";
                    VisibleDate += entered;
                    txtSelectedDate.Text = VisibleDate + "_ _  _ _:_ _";
                    break;
                case 7:
                    VisibleDate += "";
                    VisibleDate += entered;
                    txtSelectedDate.Text = VisibleDate + "_  _ _:_ _";
                    break;
                case 8:
                    VisibleDate += "";
                    VisibleDate += entered;
                    txtSelectedDate.Text = VisibleDate + " _ _:_ _";
                    txtGuide.Text = "Podaj godzinę";
                    break;
                case 9:
                    VisibleDate += " ";
                    VisibleDate += entered;
                    txtSelectedDate.Text = VisibleDate + "_:_ _";
                    break;
                case 10:
                    VisibleDate += "";
                    VisibleDate += entered;
                    txtSelectedDate.Text = VisibleDate + ":_ _";
                    txtGuide.Text = "Podaj minuty";
                    break;
                case 11:
                    VisibleDate += ":";
                    VisibleDate += entered;
                    txtSelectedDate.Text = VisibleDate + "_";
                    break;
                case 12:
                    VisibleDate += "";
                    VisibleDate += entered;
                    txtSelectedDate.Text = VisibleDate;
                    dtKeyboard.IsOpen = false;
                    ValidateDate();
                    break;


            }

            InputCounter++;
        }

        /// <summary>
        /// Sprawdzanie poprawności wpisanej daty
        /// </summary>
        private void ValidateDate()
        {
            DateTime dt;
            string s = txtSelectedDate.Text;

            //MessageDialog md = new MessageDialog(s[0].ToString() + s[1].ToString());

            int dzien = Convert.ToInt32(s[0].ToString() + s[1].ToString());
            int miesiac = Convert.ToInt32(s[3].ToString() + s[4].ToString());
            int rok = Convert.ToInt32(s[6].ToString() + s[7].ToString() + s[8].ToString() + s[9].ToString());
            int godzina = Convert.ToInt32(s[11].ToString() + s[12].ToString());
            int minuta = Convert.ToInt32(s[14].ToString() + s[15].ToString());

            try
            {
                dt = new DateTime(rok, miesiac, dzien, godzina, minuta, 0);
                selectedDate = dt;
                txtSelectedDate.Foreground = new SolidColorBrush(Colors.White);
            }
            catch (Exception)
            {
                txtSelectedDate.Text = "Błędny format";
                txtSelectedDate.Foreground = new SolidColorBrush(Colors.SkyBlue);
            }
        }
    }
}
