﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections; 
using Windows.Storage;
using Windows.UI.Popups;
using Windows.UI.ViewManagement;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

// The Split Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234234

namespace MojeSpotkania
{
    /// <summary>
    /// Strona wyświetla listę elementów RSS oraz szczegółowe informacje na temat jednego (zaznaczonego) z nich.
    /// </summary>
    public sealed partial class RssStrona : MojeSpotkania.Common.LayoutAwarePage
    {

        Roaming daneRoaming = new Roaming();
        string obecnieCzytanyRSS;
        public RssStrona()
        {
            this.InitializeComponent();
        }           

        void ItemListView_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            

            try
            {
                ListView lista = sender as ListView;
                ElementKanaluRSS obiekt = lista.Items[this.itemsViewSource.View.CurrentPosition] as ElementKanaluRSS;

                wvText.NavigateToString("<html><style>a {color:#87CEEB;}</style><body style=\"background-color: #006FC4; color: white; font-family:Segoe UI;\">" + obiekt.Tresc + "</body></html>");

                ApplicationView.TryUnsnap();

                if (obiekt != null)
                {
                    obecnieCzytanyRSS = obiekt.Tytul;
                }
            }
            catch (ArgumentOutOfRangeException)
            {
                //odznaczono obiekt.
                wvText.NavigateToString("<html><body style=\"background-color: #006FC4; color: white; font-family:Segoe UI;\"> </body></html>");
            }
            if (this.UsingLogicalPageNavigation()) this.InvalidateVisualState();
        }
        
        #region Zarządzanie stanem strony

        /// <summary>
        /// Zapełnia stronę z treścią pozyskaną w czasie nawigacji. Zapisany stan może być załadowany niezależnie czy należy do tej czy do poprzedniej sesji.
        /// </summary>
        /// <param name="navigationParameter">Wartości parametrów przekazywane są do 
        /// Frame.Navigate(Type, Object) przy inicjalizacji strony
        /// </param>
        /// <param name="pageState">Słownik stanu przechowywany przez strony podczas wcześniejszych sesji. Przy braku zapisanego stanu (np. przy pierwszym uruchomieniu) jego wartość będzie null
        /// </param>
        protected override async void LoadState(Object navigationParameter, Dictionary<String, Object> pageState)
        {
            // TODO: Assign a bindable group to this.DefaultViewModel["Group"]
            KanalyRSS zrodla = new KanalyRSS();
            string tekstKomunikatu = "";
            try
            {
                await zrodla.PobierzKanalyRSS();

                itemsViewSource.Source = (zrodla.Kanaly).First().ObiektyKanaluRSS;
            }
            catch (Exception exc)
            {
                tekstKomunikatu = "Wystąpił błąd podczas łączenia się z którymś z kanałów.\nBłąd: " + exc.Message;
                
            }
            if (tekstKomunikatu != "")
            {
                MessageDialog komunikat = new MessageDialog(tekstKomunikatu);
                await komunikat.ShowAsync();
                this.Frame.Navigate(typeof(MainPage));
            }

            if (pageState == null)
            {
                // Kiedy otwierana jest nowa strona zaznacza się automatycznie pierwszy element, chyba, że zostanie wskazane inaczej przez logikę nawigacji
                if (!this.UsingLogicalPageNavigation() && this.itemsViewSource.View != null)
                {
                    obecnieCzytanyRSS = daneRoaming.ZaładujOstatnioCzytanyObiektKanaluRSS();

                    if (obecnieCzytanyRSS != null)
                    {
                        bool ostatnioCzytanyNadalIstnieje = false;
                        foreach (ElementKanaluRSS obiekt in itemsViewSource.View)
                        {
                            if (obiekt.Tytul == obecnieCzytanyRSS)
                            {
                                ostatnioCzytanyNadalIstnieje = true;
                                itemListView.SelectedItem = obiekt;
                            }
                        }
                        if (!ostatnioCzytanyNadalIstnieje)
                        {
                            MessageDialog komunikat = new MessageDialog("Ostatnio czytane źródło nie znajduje się w najnowszych źródłach kanału RSS. Być może jest już przedawnione, zostało usunięte w serwisie lub zmieniony został kanał RSS.");
                            await komunikat.ShowAsync();
                        }
                    }
                    else
                    {
                        this.itemsViewSource.View.MoveCurrentToFirst();                        
                    }
                }
            }
            else
            {
                // Przywraca ostatnio zapisany stan dla przypadku, gdy stan strony nie jest null. 
                if (pageState.ContainsKey("SelectedItem") && this.itemsViewSource.View != null)
                {
                }
            }
        }

        /// <summary>
        /// Wywoływany kiedy element listy zostaje zaznaczony
        /// </summary>
        /// <param name="sender">GridView (lub ListView jesli aplikacja jest w trybie snapped)
        /// wyświetlający zaznaczony element.</param>
        /// <param name="e">Zdarzenie danych, które opisują jak zostało zmionione zaznaczenie.</param>
        private async void itemDetail_Tapped(object sender, TappedRoutedEventArgs e)
        {
            int selected = -1;
            try
            {
                for (int i = 0; i < (itemListView.Items.Count - 1); i++)
                {
                    if (itemListView.SelectedItem == itemListView.Items[i])
                        selected = i;
                }

                ElementKanaluRSS obiekt = itemListView.Items[selected] as ElementKanaluRSS;
                Uri uri = new Uri(obiekt.Link.ToString());
                await Windows.System.Launcher.LaunchUriAsync(uri);


            }
            catch (Exception)
            {
            }
        }

        /// <summary>
        /// Wywoływany kiedy zostanie kliknięty element w oknie wyświetlającym treść elementu z listy
        /// </summary>
        /// <param name="sender">GridView (lub ListView jesli aplikacja jest w trybie snapped)
        /// wyświetlający zaznaczony element.</param>
        /// <param name="e">Zdarzenie danych, które opisują jak zostało zmionione zaznaczenie.</param>
        private async void wvText_Tapped(object sender, TappedRoutedEventArgs e)
        {
            int selected = -1;
            try
            {
                for (int i = 0; i < (itemListView.Items.Count - 1); i++)
                {
                    if (itemListView.SelectedItem == itemListView.Items[i])
                        selected = i;
                }

                ElementKanaluRSS obiekt = itemListView.Items[selected] as ElementKanaluRSS;
                Uri uri = new Uri(obiekt.Link.ToString());
                await Windows.System.Launcher.LaunchUriAsync(uri);
            }
            catch (Exception)
            {
            }
        }

        /// <summary>
        /// Przechowuje stan powiązany ze stroną na wypadek gdyby aplikacja została wstrzymana lub usunięta z cache nawigacji.
        /// Wartości muszą dawać się serializować zgodnie z wymaganiami SuspensionManager.SessionState
        /// </summary>
        /// <param name="pageState">Pusty słownik, który zostanie zapełniony serializowanym stanem.</param>
        protected override void SaveState(Dictionary<String, Object> pageState)
        {
            string tytul = "";
            try
            {
                if (this.itemsViewSource.View != null)
                {
                    int index = this.itemsViewSource.View.CurrentPosition;
                    tytul = (this.itemsViewSource.View[index] as ElementKanaluRSS).Tytul;
                    daneRoaming.ZapiszOstatnioCzytanyObiektKanaluRSS(tytul);
                    ApplicationData.Current.SignalDataChanged();
                }
            }
            catch (ArgumentOutOfRangeException)
            {
                daneRoaming.ZapiszOstatnioCzytanyObiektKanaluRSS(null); //proba zapisania elementu o indeksie -1. Przechwycamy to i obslugujemy.
            }
        }

        #endregion

        #region Zarządzanie logiką nawigacji

        /// <summary>
        /// Wywoływany przy określaniu kiedy strona powinna zachowywać się jako jedna strona logiczna, a kiedy jak dwie.
        /// </summary>
        /// <param name="viewState">Stan widoku dla którego odpytuje się widok strony lub wartość null dla obecnego stanu widoku. Parametr ten jest opcjonalny z domyślną wartością null.</param>
        /// <returns>Zwraca True kiedy stan widoku dla odpytywanego widoku jest typu portait lub snapped, a false jeśli jest inaczej.</returns>
        private bool UsingLogicalPageNavigation(ApplicationViewState? viewState = null)
        {
            if (viewState == null) viewState = ApplicationView.Value;
            return viewState == ApplicationViewState.FullScreenPortrait ||
                viewState == ApplicationViewState.Snapped;
        }

        /// <summary>
        /// Wywoływany kiedy zostanie wciśnięty hardware'owy przycisk powrotu.
        /// </summary>
        /// <param name="sender">Instancja przycisku powrotu.</param>
        /// <param name="e">Zdarzenie danych, który opisuje zachowanie przycisku.</param>
        protected override void GoBack(object sender, RoutedEventArgs e)
        {
            if (this.UsingLogicalPageNavigation() && itemListView.SelectedItem != null)
            {
            }
            else
            {
                base.GoBack(sender, e);
            }
        }

        /// <summary>
        /// Wywoływany do określenia nazwy widocznego stanu, który odpowiada widokowi stanu aplikacji.
        /// </summary>
        /// <param name="viewState">Stan widoku, który jest odpytywany.</param>
        /// <returns>Nazwa stanu wizualnego.</returns>
        protected override string DetermineVisualState(ApplicationViewState viewState)
        {
            // aktualizacja dostępności przycisku powrotu przy zmianie stanu widoku
            var logicalPageBack = this.UsingLogicalPageNavigation(viewState) && this.itemListView.SelectedItem != null;
            var physicalPageBack = this.Frame != null && this.Frame.CanGoBack;
            this.DefaultViewModel["CanGoBack"] = logicalPageBack || physicalPageBack;

            // Determinuje stan wizualny dla widoku poziomego bazującego nie na stanie widoku, a na szerokości okna aplikacji. 
            // Strona ta posiada jeden układ, który jest odpowiedni dla ekranów o szerokości minimum 1366 pikseli, a drugi dla węższych wyświetlaczy, lub, gdy aplikacja będąca w trypie snapped posiada mniej szerokościu niż wymagane 1366 pikseli.
            if (viewState == ApplicationViewState.Filled ||
                viewState == ApplicationViewState.FullScreenLandscape)
            {
                var windowWidth = Window.Current.Bounds.Width;
                if (windowWidth >= 1366) return "FullScreenLandscapeOrWide";
                return "FilledOrNarrow";
            }

            // Kiedy jest uruchamiany tryb portrait lub snapped z domyślną nazwą stanu wizualnego, wtedy zostaje dodany przyrostek
            var defaultStateName = base.DetermineVisualState(viewState);
            return logicalPageBack ? defaultStateName + "_Detail" : defaultStateName;
        }

        #endregion

    }
}
