﻿using NotificationsExtensions.BadgeContent;
using NotificationsExtensions.TileContent;
using NotificationsExtensions.ToastContent;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.Foundation;
using Windows.UI.Notifications;
using Windows.UI.StartScreen;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Media;
using Windows.Storage;
using Windows.ApplicationModel.Background;
using Windows.UI.Popups;
using Windows.Data.Xml.Dom;

namespace MojeSpotkania
{
    public class Powiadomienia
    {
        string logoMalegoKafelka = "Assets/SplashScreen.scale-100.png";
        string logoSzerokiegoKafelka = "Assets/SplashScreen.scale-100.png";             

        string TytulKafelka;
        string TrescKafelka;
        string TagKafelka;

        bool DataUstawiona = false;
        DateTime DataWygasnieciaKafelka;

        bool KolejkaStronKafelkaAplikacjiWlaczona = false;

        MessageDialog komunikat;

        /// <summary>
        /// Uniwersalna metoda do tworzenia kafelka aplikacji
        /// </summary>
        public void UniwersalnaStronaKafelka()
        {
            ITileSquarePeekImageAndText02 malyKafelek = TileContentFactory.CreateTileSquarePeekImageAndText02();
            malyKafelek.TextHeading.Text = TytulKafelka;
            malyKafelek.TextBodyWrap.Text = TrescKafelka;
            malyKafelek.Image.Src = logoMalegoKafelka;
            malyKafelek.Branding = TileBranding.None;

            ITileWideSmallImageAndText05 szerokiKafelek = TileContentFactory.CreateTileWideSmallImageAndText05();
            szerokiKafelek.TextHeading.Text = TytulKafelka;
            szerokiKafelek.TextBodyWrap.Text = TrescKafelka;
            szerokiKafelek.Image.Src = logoSzerokiegoKafelka;
            szerokiKafelek.SquareContent = malyKafelek;
            szerokiKafelek.Branding = TileBranding.Name;

            TileNotification powiadomienieKafelka = szerokiKafelek.CreateNotification();
            powiadomienieKafelka.Tag = TagKafelka;

            if (DataUstawiona && DataWygasnieciaKafelka > DateTime.Now) 
                if (DataWygasnieciaKafelka != (new DateTime()))
                    powiadomienieKafelka.ExpirationTime = DataWygasnieciaKafelka.ToLocalTime();

            TileUpdateManager.CreateTileUpdaterForApplication().EnableNotificationQueue(KolejkaStronKafelkaAplikacjiWlaczona);
            TileUpdateManager.CreateTileUpdaterForApplication().Update(powiadomienieKafelka);
        }



        /// <summary>
        /// Metoda dodawania strony do podstawowego kafelka.
        /// Wykorzystany szablon:
        /// Maly: PeekImageAndText02
        /// Duzy: SmallImageAndText05
        /// źródło obrazu jest zaciągane z pliku Assets.
        /// </summary>
        /// <param name="tytul">Tytuł wiadomości w kafelku</param>
        /// <param name="tresc">Treść wiadomości w kafelku</param>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        public void DodajStroneKafelkaAplikacji(string tytul, string tresc, string tag)
        {
            TytulKafelka = tytul;
            TrescKafelka = tresc;
            TagKafelka = tag;
            DataUstawiona = false;
            KolejkaStronKafelkaAplikacjiWlaczona = false;
            UniwersalnaStronaKafelka();

        }

        /// <summary>
        /// Metoda dodawania strony do podstawowego kafelka.
        /// Wykorzystany szablon:
        /// Maly: PeekImageAndText02
        /// Duzy: SmallImageAndText05
        ///  źródło obrazu jest zaciągane z pliku Assets.
        /// </summary>
        /// <param name="tytul">Tytuł wiadomości w kafelku</param>
        /// <param name="tresc">Treść wiadomości w kafelku</param>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        /// <param name="dataWygasniecia">Data wygaśniecia (usunięcia) strony kafelka. Data wczesniejsza niż dziś oznacza brak limitu czasowego.</param>
        public void DodajStroneKafelkaAplikacji(string tytul, string tresc, string tag, DateTime dataWygasniecia)
        {
            TytulKafelka = tytul;
            TrescKafelka = tresc;
            TagKafelka = tag;
            DataWygasnieciaKafelka = dataWygasniecia;
            DataUstawiona = true;

            UniwersalnaStronaKafelka();
        }

        /// <summary>
        /// Metoda dodawania strony do podstawowego kafelka.
        /// Wykorzystany szablon:
        /// Maly: PeekImageAndText02
        /// Duzy: SmallImageAndText05
        /// Źródło obrazu jest zaciągane z pliku Assets.
        /// </summary>
        /// <param name="tytul">Tytuł wiadomości w kafelku</param>
        /// <param name="tresc">Treść wiadomości w kafelku</param>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        /// <param name="dataWygasniecia">Data wygaśnięcia (usunięcia) strony kafelka. Data wczesniejsza niż dziś oznacza brak limitu czasowego.</param>
        /// <param name="KolejkaKafelkowWlaczona">Kolejkowanie. True oznacza, ze strony kafelka będą się przewijać. False oznacza, ze wyświetli się ostatnio dodana strona kafelka</param>
        public void DodajStroneKafelkaAplikacji(string tytul, string tresc, string tag, DateTime dataWygasniecia, bool kolejkaKafelkowWlaczona)
        {
            TytulKafelka = tytul;
            TrescKafelka = tresc;
            TagKafelka = tag;
            DataWygasnieciaKafelka = dataWygasniecia;
            DataUstawiona = true;
            KolejkaStronKafelkaAplikacjiWlaczona = kolejkaKafelkowWlaczona;

            UniwersalnaStronaKafelka();
        }

        /// <summary>
        /// Metoda edytowania strony podstawowego kafelka.
        /// Wykorzystany szablon:
        /// Maly: PeekImageAndText02
        /// Duzy: SmallImageAndText05
        /// Źródło obrazu jest zaciągane z pliku Assets.
        /// </summary>
        /// <param name="tytul">Tytuł wiadomości w kafelku</param>
        /// <param name="tresc">Treść wiadomości w kafelku</param>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        public void EdytujStroneKafelkaAplikacji(string tytul, string tresc, string tag)
        {
            DodajStroneKafelkaAplikacji(tytul, tresc, tag);
        }

        /// <summary>
        /// Metoda edytowania strony podstawowego kafelka.
        /// Wykorzystany szablon:
        /// Maly: PeekImageAndText02
        /// Duzy: SmallImageAndText05
        /// Źródło obrazu jest zaciągane z pliku Assets.
        /// </summary>
        /// <param name="tytul">Tytuł wiadomości w kafelku</param>
        /// <param name="tresc">Treść wiadomości w kafelku</param>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        /// <param name="dataWygasniecia">Data wygaśniecia (usunięcia) strony kafelka. Data wczesniejsza niż dziś oznacza brak limitu czasowego.</param>
        public void EdytujStroneKafelkaAplikacji(string tytul, string tresc, string tag, DateTime dataWygasniecia)
        {
            DodajStroneKafelkaAplikacji(tytul, tresc, tag, dataWygasniecia);
        }

        /// <summary>
        /// Metoda edytowania strony podstawowego kafelka.
        /// Wykorzystany szablon:
        /// Maly: PeekImageAndText02
        /// Duzy: SmallImageAndText05
        /// Źródło obrazu jest zaciągane z pliku Assets.
        /// </summary>
        /// <param name="title">Tytuł wiadomości w kafelku</param>
        /// <param name="content">Treść wiadomości w kafelku</param>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        /// <param name="dataWygasniecia">Data wygaśnięcia (usunięcia) strony kafelka. Data wczesniejsza niż dziś oznacza brak limitu czasowego.</param>
        /// <param name="kolejkaKafelkowWlaczona">Kolejkowanie. True oznacza, ze strony kafelka będą się przewijać. False oznacza, ze wyświetli się ostatnio dodana strona kafelka</param>
        public void EdytujStroneKafelkaAplikacji(string title, string content, string tag, DateTime dataWygasniecia, bool kolejkaKafelkowWlaczona)
        {
            DodajStroneKafelkaAplikacji(title, content, tag, dataWygasniecia, kolejkaKafelkowWlaczona);
        }

        /// <summary>
        /// Usuwanie strony kafelka.
        /// </summary>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona usuwanego kafelka.</param>
        public void UsunStroneKafelkaAplikacji(string tag)
        {
            DodajStroneKafelkaAplikacji("ClosingTile...", "Tile is saying: 'Bye World'", tag, DateTime.Now.AddSeconds(1));
        }

        /// <summary>
        /// Usuniecie wszystkich stron kafelka i powrot do domyslnego wygladu
        /// </summary>
        public void UsunWszystkieStronyKafelkaAplikacji()
        {

            TileUpdateManager.CreateTileUpdaterForApplication().Clear();
        }

        /// <summary>
        /// Metoda dodawania zaplanowanej strony kafelka.
        /// Wykorzystany szablon:
        /// Maly: PeekImageAndText02
        /// Duzy: SmallImageAndText05
        /// Źródło obrazu jest zaciągane z pliku Assets.
        /// </summary>
        /// <param name="tytul">Tytuł wiadomości w kafelku</param>
        /// <param name="tresc">Treść wiadomości w kafelku</param>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        /// <param name="kolejkaStronKafelkaWlaczona">Kolejkowanie. True oznacza, ze strony kafelka będą się przewijać. False oznacza, ze wyświetli się ostatnio dodana strona kafelka</param>
        /// <param name="DataUruchomienia">Data pojawienia się strony na kafelku.</param>
        /// <param name="DataWygasnieciaStronyKafelka">Data wygaśnięcia (usunięcia) strony kafelka. Data wczesniejsza niż dziś oznacza brak limitu czasowego.</param>
        public async void DodajPlanowanaStroneKafelkaAplikacji(string tytul, string tresc, string tag, bool kolejkaStronKafelkaWlaczona, DateTime DataUruchomienia, DateTime DataWygasnieciaStronyKafelka)
        {
            string trescKomunikatu = "";
            try
            {
                ITileSquarePeekImageAndText02 malyKafelek = TileContentFactory.CreateTileSquarePeekImageAndText02();
                malyKafelek.TextHeading.Text = tytul;
                malyKafelek.TextBodyWrap.Text = tresc;
                malyKafelek.Image.Src = logoMalegoKafelka; //"ms-appx:///Assets/logo.scale-100.png"        
                malyKafelek.Branding = TileBranding.None;

                ITileWideSmallImageAndText05 szerokiKafelek = TileContentFactory.CreateTileWideSmallImageAndText05();
                szerokiKafelek.TextHeading.Text = tytul;
                szerokiKafelek.TextBodyWrap.Text = tresc;
                szerokiKafelek.Image.Src = logoSzerokiegoKafelka;
                szerokiKafelek.SquareContent = malyKafelek;
                szerokiKafelek.Branding = TileBranding.Name;

                TileNotification powiadomienieKafelka = szerokiKafelek.CreateNotification();

                ScheduledTileNotification zaplanowanaStronaKafelka = new ScheduledTileNotification(powiadomienieKafelka.Content, DataUruchomienia.ToLocalTime());
                zaplanowanaStronaKafelka.Id = tag;

                if (DataWygasnieciaStronyKafelka > DateTime.Now)
                    zaplanowanaStronaKafelka.ExpirationTime = DataWygasnieciaStronyKafelka.ToLocalTime();

                TileUpdateManager.CreateTileUpdaterForApplication().EnableNotificationQueue(kolejkaStronKafelkaWlaczona);
                TileUpdateManager.CreateTileUpdaterForApplication().AddToSchedule(zaplanowanaStronaKafelka);
            }
            catch (Exception exc)
            {
                trescKomunikatu = "Wystąpił błąd podczas dodawania planowanej strony kafelka aplikacji: " + exc.Message;
            }
            if (trescKomunikatu != "")
            {
                MessageDialog komunikat = new MessageDialog(trescKomunikatu);
                await komunikat.ShowAsync();
            }

        }

        /// <summary>
        /// Metoda edytowania zaplanowanej strony kafelka. Metoda przekazuje edytowany kafelek do roamingu.
        /// Wykorzystany szablon:
        /// Maly: PeekImageAndText02
        /// Duzy: SmallImageAndText05
        /// Źródło obrazu jest zaciągane z pliku Assets.
        /// </summary>
        /// <param name="tytul">Tytuł wiadomości w kafelku</param>
        /// <param name="tresc">Treść wiadomości w kafelku</param>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        /// <param name="kolejkaStronKafelkaWlaczona">Kolejkowanie. True oznacza, ze strony kafelka będą się przewijać. False oznacza, ze wyświetli się ostatnio dodana strona kafelka</param>
        /// <param name="DataUruchomienia">Data pojawienia się strony na kafelku.</param>
        /// <param name="DataWygasnieciaStronyKafelka">Data wygaśnięcia (usunięcia) strony kafelka. Data wczesniejsza niż dziś oznacza brak limitu czasowego.</param>
        public async void EdytujZaplanowaStroneKafelka(string tytul, string tresc, string tag, bool kolejkaStronKafelkaWlaczona, DateTime DataUruchomienia, DateTime DataWygasnieciaStronyKafelka)
        {
            string trescKomunikatu = "";
            try
            {
                TileUpdater aktualizator = TileUpdateManager.CreateTileUpdaterForApplication();
                var stronyKafelka = aktualizator.GetScheduledTileNotifications();
                for (int i = 0; i < stronyKafelka.Count; i++)
                {
                    if (stronyKafelka[i].Id == tag)
                    {
                        DodajPlanowanaStroneKafelkaAplikacji(tytul, tresc, tag, kolejkaStronKafelkaWlaczona, DataUruchomienia, DataWygasnieciaStronyKafelka);
                    }
                }
            }
            catch (ArgumentException exc)
            {
                trescKomunikatu = "Wystąpił błąd podczas edytowania planowanej strony kafelka aplikacji: " + exc.Message;                
            }
            if (trescKomunikatu != "")
            {
                MessageDialog komunikat = new MessageDialog(trescKomunikatu);
                await komunikat.ShowAsync();
            }
        }

        /// <summary>
        /// Metoda usuwająca zaplanowana strone kafelka.
        /// </summary>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        public void UsunZaplanowanaStroneKafelka(string tag)
        {            
            TileUpdater aktualizator = TileUpdateManager.CreateTileUpdaterForApplication();
            var stronyKafelka = aktualizator.GetScheduledTileNotifications();
            for (int i = 0; i < stronyKafelka.Count; i++)
            {
                if (stronyKafelka[i].Id == tag)
                {
                    aktualizator.RemoveFromSchedule(stronyKafelka[i]);
                }
            }            
        }

        /// <summary>
        /// Metoda dodająca kafelek pomocniczy.
        /// Szablon kafelka:
        /// Mały: PeekImageAndText02
        /// Duży: SmallImageAndText05
        /// Źródło obrazu jest zaciągane z pliku Assets.
        /// </summary>
        /// <param name="tytul">Tytuł wiadomości w kafelku</param>
        /// <param name="tresc">Treść wiadomości w kafelku</param>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        /// <param name="IdSpotkania">id spotkania z którego jest wysyłane zapytanie</param>
        /// <param name="sender">obiekt wywołujący np button.</param>        
        public async void DodajKafelekPomocniczy(string tytul, string tresc, string tag, int IdSpotkania, object sender)
        {
            SecondaryTile kafelekPomocniczy = new SecondaryTile(tag, tytul, tytul, IdSpotkania.ToString(), TileOptions.ShowNameOnLogo | TileOptions.ShowNameOnWideLogo,
                new Uri("ms-appx:///" + logoMalegoKafelka), new Uri("ms-appx:///"+ logoSzerokiegoKafelka));
            
            bool przypiety = await kafelekPomocniczy.RequestCreateForSelectionAsync(PobierzRamyElementu((FrameworkElement)sender), Windows.UI.Popups.Placement.Above);
            if (przypiety)
            {
                ITileSquarePeekImageAndText02 malyKafelek = TileContentFactory.CreateTileSquarePeekImageAndText02();
                malyKafelek.TextHeading.Text = tytul;
                malyKafelek.TextBodyWrap.Text = tresc;
                malyKafelek.Image.Src = logoMalegoKafelka; //"ms-appx:///Assets/logo.scale-100.png"       
                malyKafelek.Branding = TileBranding.None;

                ITileWideSmallImageAndText05 szerokiKafelek = TileContentFactory.CreateTileWideSmallImageAndText05();
                szerokiKafelek.TextHeading.Text = tytul;
                szerokiKafelek.TextBodyWrap.Text = tresc;
                szerokiKafelek.Image.Src = logoSzerokiegoKafelka;
                szerokiKafelek.SquareContent = malyKafelek;
                szerokiKafelek.Branding = TileBranding.Name;

                TileNotification powiadomienieKafelka = szerokiKafelek.CreateNotification();
                powiadomienieKafelka.Tag = tag;

                TileUpdateManager.CreateTileUpdaterForSecondaryTile(tag).Update(powiadomienieKafelka);
            }
        }

        /// <summary>
        /// Metoda edytująca kafelek
        /// /// Szablon kafelka:
        /// Mały: PeekImageAndText02
        /// Duży: SmallImageAndText05
        /// Źródło obrazu jest zaciągane z pliku Assets.
        /// </summary>
        /// <param name="tytul">Tytuł wiadomości w kafelku</param>
        /// <param name="tresc">Treść wiadomości w kafelku</param>
        /// <param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        public void EdytujPomocniczyKafelek(string tytul, string tresc, string tag)
        {
            ITileSquarePeekImageAndText02 small = TileContentFactory.CreateTileSquarePeekImageAndText02();
            small.TextHeading.Text = tytul;
            small.TextBodyWrap.Text = tresc;
            small.Image.Src = logoMalegoKafelka; //"ms-appx:///Assets/logo.scale-100.png"       
            small.Branding = TileBranding.None; 

            ITileWideSmallImageAndText05 big = TileContentFactory.CreateTileWideSmallImageAndText05();
            big.TextHeading.Text = tytul;
            big.TextBodyWrap.Text = tresc;
            big.Image.Src = logoSzerokiegoKafelka;
            big.SquareContent = small;
            big.Branding = TileBranding.Name;

            TileNotification powiadomienieKafelka = big.CreateNotification();
            powiadomienieKafelka.Tag = tag;

            TileUpdateManager.CreateTileUpdaterForSecondaryTile(tag).Update(powiadomienieKafelka);
        }

        /// <summary>
        /// Metoda usuwająca kafelek
        /// </summary>
        ///<param name="tag">Unikalny tag po jakim zostanie odnaleziona strona edytowanego kafelka</param>
        /// <param name="sender">obiekt wywołujący np button.</param>  
        public async void UsunPomocniczyKafelek(string tag, object sender)
        {
            SecondaryTile pomocniczyKafelek = new SecondaryTile(tag);
            await pomocniczyKafelek.RequestDeleteForSelectionAsync(
            PobierzRamyElementu((FrameworkElement)sender), Windows.UI.Popups.Placement.Above);
        }

        public static Rect PobierzRamyElementu(FrameworkElement element)
        {
            GeneralTransform buttonTransform = element.TransformToVisual(null);
            Point point = buttonTransform.TransformPoint(new Point());
            return new Rect(point, new Size(element.ActualWidth, element.ActualHeight));
        }
 
        /// <summary>
        /// Metoda tworząca powiadomienie toast i zapisująca powiadomienie w roamingu
        /// </summary>
        /// <param name="IdSpotkania">id spotkania z którego jest wysyłane zapytanie</param>
        /// <param name="tytul">Tytuł wiadomości w kafelku</param>
        /// <param name="tresc">Treść wiadomości w kafelku</param>
        /// <param name="DataUruchomienia">Data pojawienia się strony na kafelku.</param>
        public async void DodajWyskakujacePowiadomienie(int IdSpotkania, string tytul, string tresc, DateTime DataUruchomienia)
        {
            string trescKomunikatu = "";
            try
            {
                IToastText02 iPowiad = ToastContentFactory.CreateToastText02();
                iPowiad.Audio.Content = ToastAudioContent.LoopingAlarm2;
                iPowiad.Duration = ToastDuration.Long;
                iPowiad.Audio.Loop = true;
                iPowiad.TextHeading.Text = tytul;
                iPowiad.TextBodyWrap.Text = tresc;
                iPowiad.Launch = IdSpotkania.ToString();                
                ToastNotification powiadomienie = iPowiad.CreateNotification();

                if (DataUruchomienia > DateTime.Now)
                {
                    ScheduledToastNotification plan = new ScheduledToastNotification(powiadomienie.Content, DataUruchomienia);
                    
                    
                    plan.Id = IdSpotkania.ToString();
                    ToastNotificationManager.CreateToastNotifier().AddToSchedule(plan);


                }
                else
                {
                    ToastNotificationManager.CreateToastNotifier().Show(powiadomienie);                  
                }
                

            }
            catch (Exception exc)
            {
                trescKomunikatu = "Wystąpił błąd podczas dodawania wyskakującego powiadomienia: " + exc.Message;                
            }
            if (trescKomunikatu != "") 
            {
                komunikat = new MessageDialog(trescKomunikatu);
                await komunikat.ShowAsync();
            }
        }

        /// <summary>
        /// Metoda edytująca wyskakujące powiadomienie i zapisująca powiadomienie w roamingu
        /// </summary>
        /// <param name="IdSpotkania">id spotkania z którego jest wysyłane zapytanie</param>
        /// <param name="tytul">Tytuł wiadomości w kafelku</param>
        /// <param name="tresc">Treść wiadomości w kafelku</param>
        /// <param name="DataUruchomienia">Data pojawienia się strony na kafelku.</param>
        public async void EditToast(int IdSpotkania, string tytul, string tresc, DateTime DataUruchomienia)
        {
            string trescKomunikatu = "";
            try
            {
                ToastNotifier wyskakujacePowiadomienie = ToastNotificationManager.CreateToastNotifier();
                var zaplanowanePowiadomienia = wyskakujacePowiadomienie.GetScheduledToastNotifications();
                for (int i = 0; i < zaplanowanePowiadomienia.Count; i++)
                {
                    if (zaplanowanePowiadomienia[i].Id == IdSpotkania.ToString())
                    {
                        DodajWyskakujacePowiadomienie(IdSpotkania, tytul, tresc, DataUruchomienia);
                    }
                }
            }
            catch (ArgumentException exc)
            {
                trescKomunikatu = "Wystąpił błąd podczas edytowania wyskakującego powiadomienia: " + exc.Message;
            }
            if (trescKomunikatu != "")
            {
                komunikat = new MessageDialog(trescKomunikatu);
                await komunikat.ShowAsync();
            }
        }

        /// <summary>
        /// Metoda usuwająca powiadomienie toast i kasująca powiadomienie z roamingu
        /// </summary>
        /// <param name="IdSpotkania"></param>
        public void UsunWyskakujacePowiadomienie(int IdSpotkania)
        {
          
            ToastNotifier wyskakujacePowiadomienie = ToastNotificationManager.CreateToastNotifier();
            var zaplanowanePowiadomienia = wyskakujacePowiadomienie.GetScheduledToastNotifications();
            for (int i = 0; i < zaplanowanePowiadomienia.Count; i++)
            {
                if (zaplanowanePowiadomienia[i].Id ==IdSpotkania.ToString())
                {
                    wyskakujacePowiadomienie.RemoveFromSchedule(zaplanowanePowiadomienia[i]);
                }
            }            
        }


        /// <summary>
        /// Usunięcie wszystkich zaplanowanych wyskakujących powiadomień i i kasująca powiadomienia z roamingu
        /// </summary>
        public void UsunWszystkieZaplanowaneWyskakujacePowiadomienia()
        {
            ToastNotifier wyskakujacePowiadomienie = ToastNotificationManager.CreateToastNotifier();
            var zaplanowanePowiadomienia = wyskakujacePowiadomienie.GetScheduledToastNotifications();
            for (int i = 0; i < zaplanowanePowiadomienia.Count; i++)
            {
                wyskakujacePowiadomienie.RemoveFromSchedule(zaplanowanePowiadomienia[i]);
            }
           
        }

        /// <summary>
        /// Dodanie wskaźnika numerycznego
        /// </summary>
        /// <param name="numer">Numer wskaźnika. Przy wartości mniejszej lub równej 0 zostanie wyświetlone '0'. Przy wartości większej niż 99 zostanie wyświetlone '99+'</param>
        public void DodajWskaznikZNumerem(int numer)
        {
            BadgeNumericNotificationContent wskaznik = new BadgeNumericNotificationContent((uint)numer);
            BadgeUpdateManager.CreateBadgeUpdaterForApplication().Update(wskaznik.CreateNotification()); 
        }

        /// <summary>
        /// Dodanie wskaźnika z glifem
        /// </summary>
        /// <param name="glif">wybrany glif spośród zdefiniowanych</param>
        public void DodajWskaznikZGlifem(GlyphValue glif)
        {
            BadgeGlyphNotificationContent wskaznik = new BadgeGlyphNotificationContent(glif);
            BadgeUpdateManager.CreateBadgeUpdaterForApplication().Update(wskaznik.CreateNotification()); 
        }

    }
}
