﻿
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using Windows.UI.ApplicationSettings;
using Windows.UI.Popups;
using Microsoft.Live;
using Windows.UI.Xaml.Media.Imaging;
using Windows.Storage.Pickers;
using Windows.Storage;
using Windows.Storage.Streams;
using Windows.ApplicationModel.Background;
using Windows.Data.Xml.Dom;
using Windows.UI.Notifications;
using Windows.ApplicationModel.DataTransfer; 

// The Basic Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234237

namespace MojeSpotkania
{
    /// <summary>
    /// A basic page that provides characteristics common to most applications.
    /// </summary>
    public sealed partial class MainPage : MojeSpotkania.Common.LayoutAwarePage
    {
        public MainPage()
        {
            this.InitializeComponent();
        }

        List<Spotkanie> ListaSpotkan;
        Windows.Storage.ApplicationDataContainer localSettings = Windows.Storage.ApplicationData.Current.LocalSettings;
        Windows.Storage.StorageFolder localFolder = Windows.Storage.ApplicationData.Current.LocalFolder;

        private static TypedEventHandler<SettingsPane, SettingsPaneCommandsRequestedEventArgs> _zdarzenie;

        /// <summary>
        /// Populates the page with content passed during navigation.  Any saved state is also
        /// provided when recreating a page from a prior session.
        /// </summary>
        /// <param name="navigationParameter">The parameter value passed to
        /// <see cref="Frame.Navigate(Type, Object)"/> when this page was initially requested.
        /// </param>
        /// <param name="pageState">A dictionary of state preserved by this page during an earlier
        /// session.  This will be null the first time a page is visited.</param>
        protected async override void LoadState(Object navigationParameter, Dictionary<String, Object> pageState)
        {


            ApplicationDataContainer ustawieniaRoaming = ApplicationData.Current.RoamingSettings;
            ListaSpotkan = await OperacjeBazy.PobierzListeSpotkan();
            KolekcjaSpotkan.Source = ListaSpotkan;

            if (ListaSpotkan.Count == 0)
            {
                stpBrakSpotkan.Visibility = Visibility.Visible;
                gvSpotkania.Visibility = Visibility.Collapsed;
            }

            if (!ustawieniaRoaming.Containers.ContainsKey("dane") || !ustawieniaRoaming.Containers["dane"].Values.ContainsKey("kanal1RSS"))
            {
                Roaming roaming = new Roaming();
                roaming.DodajDowolnyObiektDoRoamingu("kanal1RSS", "http://finanse.wp.pl/rss.xml");
            }

            if (_zdarzenie != null)
                SettingsPane.GetForCurrentView().CommandsRequested -= _zdarzenie;

            _zdarzenie = PozycjeMenuUstawien;
            SettingsPane.GetForCurrentView().CommandsRequested += _zdarzenie;

            string tekstKomunikatu = "";

            try
            {
                LiveAuthClient uwierzytelnienie = new LiveAuthClient();
                LiveLoginResult wynikInicjalizacji = await uwierzytelnienie.InitializeAsync();
                try
                {
                    LiveLoginResult wynikLogowania = await uwierzytelnienie.LoginAsync(new string[] { "wl.basic", "wl.skydrive_update", "wl.skydrive", "wl.events_create", "wl.calendars_update" });
                    if (wynikLogowania.Status == LiveConnectSessionStatus.Connected)
                    {
                        LiveConnectClient polaczenie = new LiveConnectClient(uwierzytelnienie.Session);
                        LiveOperationResult wynikOperacji = await polaczenie.GetAsync("me");
                        dynamic wynik = wynikOperacji.Result;
                        if (wynik != null)
                        {
                            App.uwierzytelnienieKlienta = uwierzytelnienie;
                            App.polaczenieKlienta = new LiveConnectClient(App.uwierzytelnienieKlienta.Session); 
                        }
                        else
                        {
                           tekstKomunikatu = "Nie udało się powiązać konta z Kontem Microsoft.";
                        }
                    }
                }
                catch (LiveAuthException)
                {
                    tekstKomunikatu = "Wystąpił błąd podczas logowania. Sprawdź swoje dane i spróbuj ponownie.";
                }
                catch (LiveConnectException)
                {
                    tekstKomunikatu = "Wystąpił błąd podczas połączenia z kontem Microsoft Account. Sprawdź swoje połączenie z internetem lub spróbuj ponownie później.";
                }
            }
            catch (LiveAuthException)
            {
                tekstKomunikatu = "Wystąpił błąd podczas inicjalizacji połączenia. Sprawdź swoje połączenie z internetem lub spróbuj ponownie później.";
            }

            if (tekstKomunikatu != "")
            {
                MessageDialog komunikat = new MessageDialog(tekstKomunikatu);
                await komunikat.ShowAsync(); 
            }

            
        }

        /// <summary>
        /// Preserves state associated with this page in case the application is suspended or the
        /// page is discarded from the navigation cache.  Values must conform to the serialization
        /// requirements of <see cref="SuspensionManager.SessionState"/>.
        /// </summary>
        /// <param name="pageState">An empty dictionary to be populated with serializable state.</param>
        protected override void SaveState(Dictionary<String, Object> pageState)
        {
        }

        /// <summary>
        /// Metoda dodająca kola (linki) do Ustawień w pasku Charms
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="args"></param>
        private void PozycjeMenuUstawien(SettingsPane sender, SettingsPaneCommandsRequestedEventArgs args)
        {
            args.Request.ApplicationCommands.Add(new SettingsCommand("Privacy", "Polityka prywatności", StronaZewnetrzna));
            args.Request.ApplicationCommands.Add(new SettingsCommand("RSS", "RSS", StronaWewnetrzna));
            args.Request.ApplicationCommands.Add(new SettingsCommand("Settings", "Ustawienia Aplikacji", async (p) =>  
            {
                ustawieniaAplikacji.IsOpen = true;
                Roaming roaming = new Roaming();
                tbxAdresRSS.Text = (string) await roaming.ZaładujDowolnyObiektZRoamingu("kanal1RSS");
            }));
        }

        private async void StronaZewnetrzna(IUICommand command)
        {
            Uri uri = new Uri("http://dvls.pl/?page_id=239");
            await Windows.System.Launcher.LaunchUriAsync(uri);
        }

        private void StronaWewnetrzna(IUICommand command)
        {
            ((Frame)Window.Current.Content).Navigate(typeof(RssStrona));
        }

        private void DodajSpotkanie_Tapped(object sender, TappedRoutedEventArgs e)
        {
            this.Frame.Navigate(typeof(SpotkaniaStrona));
        }

        private void UsunSpotkanie_Tapped(object sender, TappedRoutedEventArgs e)
        {

        }

        private void gvSpotkania_Tapped(object sender, TappedRoutedEventArgs e)
        {
            if (gvSpotkania.SelectedIndex != -1)
            {
                Spotkanie s = (Spotkanie)gvSpotkania.SelectedItem;
                this.Frame.Navigate(typeof(SpotkaniaStrona), Convert.ToInt32(s.ID));
            }
        }

        private void lvSpotkania_Tapped(object sender, TappedRoutedEventArgs e)
        {
            if (lvSpotkania.SelectedIndex != -1)
        {
                Spotkanie s = (Spotkanie)lvSpotkania.SelectedItem;
                this.Frame.Navigate(typeof(SpotkaniaStrona), Convert.ToInt32(s.ID));
            }
        }

        private void TextBlock_Tapped_1(object sender, TappedRoutedEventArgs e)
        {
            this.Frame.Navigate(typeof(RssStrona));
        }

        private void Button_Tapped_1(object sender, TappedRoutedEventArgs e)
        {
            Roaming roaming = new Roaming();
            roaming.DodajDowolnyObiektDoRoamingu("kanal1RSS", tbxAdresRSS.Text);
        }

        private void Button_Tapped_2(object sender, TappedRoutedEventArgs e)
        {
            this.Frame.Navigate(typeof(SpotkaniaStrona));
        }

             

    }
}