﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using Windows.ApplicationModel.DataTransfer;
using Windows.ApplicationModel;
using Windows.Media.Capture;
using Windows.UI.Xaml.Media.Imaging; // dla BitmapImage
using Windows.Storage;
using Windows.Storage.Pickers;
using Windows.Storage.Streams;
using Windows.UI.Popups;
using Windows.UI.StartScreen; // dla FileAccessMode


// The Basic Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234237

namespace MojeSpotkania
{
    /// <summary>
    /// A basic page that provides characteristics common to most applications.
    /// </summary>
    public sealed partial class SpotkaniaStrona : MojeSpotkania.Common.LayoutAwarePage
    {
        public SpotkaniaStrona()
        {
            this.InitializeComponent();

            spPanel.Transitions = new Windows.UI.Xaml.Media.Animation.TransitionCollection();
            spPanel.Transitions.Add(new Windows.UI.Xaml.Media.Animation.PopupThemeTransition());


            

            // Suspending - potrzebne to + metoda onsuspending http://msdn.microsoft.com/en-us/library/windows/apps/xaml/Hh465115(v=win.10).aspx
            Application.Current.Suspending += new SuspendingEventHandler(OnSuspending);

        }

        int IDSpotkania = -1;
        Spotkanie ObecneSpotkanie;
        List<PunktAgendy> PunktyAgendy;
        SkyDrive SD;
        Powiadomienia powiadomienia = new Powiadomienia();
        
        public string ImageUri;
        BitmapImage bitmpImage = new BitmapImage();

        bool DodawanieAgendyMozliwe = false;

        private static TypedEventHandler<DataTransferManager, DataRequestedEventArgs> _handler;


        /// <summary>
        /// Populates the page with content passed during navigation.  Any saved state is also
        /// provided when recreating a page from a prior session.
        /// </summary>
        /// <param name="navigationParameter">The parameter value passed to
        /// <see cref="Frame.Navigate(Type, Object)"/> when this page was initially requested.
        /// </param>
        /// <param name="pageState">A dictionary of state preserved by this page during an earlier
        /// session.  This will be null the first time a page is visited.</param>
        protected async override void LoadState(Object navigationParameter, Dictionary<String, Object> pageState)
        {
            try
            {
                IDSpotkania = (int)navigationParameter;
                DodawanieAgendyMozliwe = true;
            }
            catch (Exception) { }

            if (IDSpotkania != -1)
            {
                ObecneSpotkanie = await OperacjeBazy.PobierzSpotkanie(IDSpotkania);

                if (ObecneSpotkanie.Zdjecie != null)
                {
                    bitmpImage.UriSource = new Uri(ObecneSpotkanie.Zdjecie, UriKind.Relative);
                    imgPotwierdzenie.Source = bitmpImage;
                    ImageUri = ObecneSpotkanie.Zdjecie;
                }

                txtNazwa.Text = ObecneSpotkanie.Nazwa;
                txtAdres.Text = ObecneSpotkanie.Adres;
                dtPoczatek.SelectedDate = ObecneSpotkanie.Poczatek;
                dtKoniec.SelectedDate = ObecneSpotkanie.Koniec;
                txtNotatka.Text = ObecneSpotkanie.Notatka;
                
                PunktyAgendy = await OperacjeBazy.PobierzPunktyAgendy(ObecneSpotkanie.ID);
                AgendaLista.Source = PunktyAgendy;

                btnZapisz.Visibility = Visibility.Collapsed;
            }
            else
            {
                grdAutozapis.Visibility = Visibility.Collapsed;
                btnZapisz.Visibility = Visibility.Visible;
                spAgendaSpotkania.Visibility = Visibility.Collapsed;
                btnDodajPunktAgendy.Visibility = Visibility.Collapsed;
                btnUsunPunktAgendy.Visibility = Visibility.Collapsed;
            }

            gvPunktyAgendy.SelectedItem = null;

            if (gvPunktyAgendy.Items.Count == 0)
            {
                gvPunktyAgendy.Visibility = Visibility.Collapsed;
                grdJakDodacPunkt.Visibility = Visibility.Visible;
            }

            if (IDSpotkania != -1)
            {
                if (_handler != null)
                    DataTransferManager.GetForCurrentView().DataRequested -= _handler;

                _handler = UdostepnijTekstHTML;
                DataTransferManager.GetForCurrentView().DataRequested += _handler;

               
            }

            if (IDSpotkania == -1)
                bottomAppBar.Visibility = Visibility.Collapsed;

        }

        /// <summary>
        /// Preserves state associated with this page in case the application is suspended or the
        /// page is discarded from the navigation cache.  Values must conform to the serialization
        /// requirements of <see cref="SuspensionManager.SessionState"/>.
        /// </summary>
        /// <param name="pageState">An empty dictionary to be populated with serializable state.</param>
        protected override void SaveState(Dictionary<String, Object> pageState)
        {
            if (IDSpotkania != -1) // Nowe spotkanie 
            {
                Spotkanie SpotkanieDoDodania = new Spotkanie
                {
                    ID = ObecneSpotkanie.ID,
                    Nazwa = txtNazwa.Text,
                    Adres = txtAdres.Text,
                    Poczatek = dtPoczatek.SelectedDate ?? new DateTime(),
                    Koniec = dtKoniec.SelectedDate ?? new DateTime(),
                    Notatka = txtNotatka.Text,
                    Zdjecie = ImageUri
                };

                OperacjeBazy.EdytujSpotkanie(SpotkanieDoDodania);
                DateTime start = dtPoczatek.SelectedDate ?? new DateTime();
                if (start != new DateTime() && start.AddHours(-1) > DateTime.Now)
                    powiadomienia.DodajWyskakujacePowiadomienie(ObecneSpotkanie.ID, txtNazwa.Text, "Za godzinę masz zaplanowane spotkanie.", start.AddHours(-1));

                AktualizujStronyKafelkaAplikacji();
            }
        }

        /// <summary>
        /// Metoda aktualizująca zawartość kafelka, wyswietlająca na niem najwczesniejsze spotkanie
        /// </summary>
        async private void AktualizujStronyKafelkaAplikacji()
        {
            Powiadomienia powiadomienia = new Powiadomienia();
            powiadomienia.UsunWszystkieStronyKafelkaAplikacji();
            int i = 0;
            List<Spotkanie> listaPosortowanaDatami = new List<Spotkanie>();
            List<Spotkanie> spotkania = await OperacjeBazy.PobierzListeSpotkan();
            while (spotkania.Count > 0 && i < 5)
            {
                Spotkanie najwczesniejsze = ZnajdzNajwczesniejszeSpotkanie(spotkania);
                if (najwczesniejsze.Poczatek > DateTime.Now)
                powiadomienia.DodajStroneKafelkaAplikacji(najwczesniejsze.Nazwa, najwczesniejsze.Notatka, najwczesniejsze.ID.ToString(), new DateTime(2113, 2, 1, 15, 0, 0), true);
                spotkania.Remove(najwczesniejsze);
                i++;
            }
        }

        /// <summary>
        /// Metoda zwracająca spotkanie, które odbędzie się najwcześniej
        /// </summary>
        /// <param name="spotkania">Lista dodanych spotkań</param>
        /// <returns>Spoktanie o najbliższej dacie</returns>
        private Spotkanie ZnajdzNajwczesniejszeSpotkanie(List<Spotkanie> spotkania)
        {
            Spotkanie najblizsze = spotkania[0];

            foreach (Spotkanie s in spotkania)
            {
                if (s.Poczatek < najblizsze.Poczatek)
                {
                    najblizsze = s;
                }
            }
            return najblizsze;
        }
        /// <summary>
        /// Invoked when application execution is being suspended.  Application state is saved
        /// without knowing whether the application will be terminated or resumed with the contents
        /// of memory still intact.
        /// </summary>
        /// <param name="sender">The source of the suspend request.</param>
        /// <param name="e">Details about the suspend request.</param>
        private void OnSuspending(object sender, SuspendingEventArgs e)
        {
            var deferral = e.SuspendingOperation.GetDeferral();
         
            if (IDSpotkania != -1) // Nowe spotkanie 
            {
                Spotkanie SpotkanieDoDodania = new Spotkanie
                {
                    ID = ObecneSpotkanie.ID,
                    Nazwa = txtNazwa.Text,
                    Adres = txtAdres.Text,
                    Poczatek = dtPoczatek.SelectedDate ?? new DateTime(),
                    Koniec = dtKoniec.SelectedDate ?? new DateTime(),
                    Notatka = txtNotatka.Text,
                    Zdjecie = ImageUri
                };

                OperacjeBazy.EdytujSpotkanie(SpotkanieDoDodania);
                DateTime start = dtPoczatek.SelectedDate ?? new DateTime();
                if (start != new DateTime() && start.AddHours(-1) > DateTime.Now)
                    powiadomienia.DodajWyskakujacePowiadomienie(ObecneSpotkanie.ID, txtNazwa.Text, "Za godzinę masz zaplanowane spotkanie.", start.AddHours(-1));

                AktualizujStronyKafelkaAplikacji();
            }

            deferral.Complete();
        }


        /// <summary>
        /// Metoda przygotowujuąca treść i format wiadomości do udostępnienia
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void UdostepnijTekstHTML(DataTransferManager sender, DataRequestedEventArgs e)
        {
            DataRequest request = e.Request;
            request.Data.Properties.Title = "Udostępnij spotkanie " + ObecneSpotkanie.Nazwa;
            request.Data.Properties.Description = "Najważniejsze informacje twojego spotkania";
            string htmlExample = "<p>Spoktanie o nazwie: " + ObecneSpotkanie.Nazwa + "</p>" + "<p>odbędzie się " + ObecneSpotkanie.Poczatek + "</p>";
            string htmlFormat = HtmlFormatHelper.CreateHtmlFormat(htmlExample);
            request.Data.SetHtmlFormat(htmlFormat);
        }
        /// <summary>
        /// Metoda zapisująca nowo dodane spotkanie
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private async void btnZapisz_Tapped(object sender, TappedRoutedEventArgs e)
        {
            if(IDSpotkania == -1) // Nowe spotkanie 
            {
                Spotkanie SpotkanieDoDodania = new Spotkanie
                {
                    Nazwa = txtNazwa.Text, 
                    Adres = txtAdres.Text,
                    Poczatek = dtPoczatek.SelectedDate ?? new DateTime(),
                    Koniec = dtKoniec.SelectedDate ?? new DateTime(),
                    Notatka = txtNotatka.Text,
                    Zdjecie = ImageUri
                };

                OperacjeBazy.DodajSpotkanie(SpotkanieDoDodania);

                int ostatnieSpotkanieID = await OperacjeBazy.OstatnieID();

                DateTime start = dtPoczatek.SelectedDate ?? new DateTime();
                if (start != new DateTime() && start.AddHours(-1) > DateTime.Now)
                    powiadomienia.DodajWyskakujacePowiadomienie(ostatnieSpotkanieID, txtNazwa.Text, "Za godzinę masz zaplanowane spotkanie.", start.AddHours(-1));

                ApplicationDataContainer ustawieniaLokalne = ApplicationData.Current.LocalSettings;
                if (!ustawieniaLokalne.Values.ContainsKey("liczbaSpotkan"))
                    ustawieniaLokalne.Values["liczbaSpotkan"] = 0;
                int liczbaSpotkan = (int)ustawieniaLokalne.Values["liczbaSpotkan"] + 1;
                ustawieniaLokalne.Values["liczbaSpotkan"] = liczbaSpotkan;
                powiadomienia.DodajWskaznikZNumerem(liczbaSpotkan);

                AktualizujStronyKafelkaAplikacji();

                this.Frame.Navigate(typeof(MainPage));
            }
 
        }

        private void UsunSpotkanie_Tapped(object sender, TappedRoutedEventArgs e)
        {
            //aktualizacja elementow na SkyDrive
            if (App.polaczenieKlienta != null && App.polaczenieKlienta.Session != null){
                if (ObecneSpotkanie.SkydriveIDKalendarza != null)
                SD.UsunObiektNaSD(ObecneSpotkanie.SkydriveIDKalendarza);
                if (ObecneSpotkanie.SkydriveIDZdjecia != null)
                SD.UsunObiektNaSD(ObecneSpotkanie.SkydriveIDZdjecia);
            }           

            //aktualizacja kafelka pomocniczego
            if (SecondaryTile.Exists(ObecneSpotkanie.ID.ToString()))                
                powiadomienia.UsunPomocniczyKafelek(ObecneSpotkanie.ID.ToString(),sender);
            
            //aktualizacja toasta
            powiadomienia.UsunWyskakujacePowiadomienie(ObecneSpotkanie.ID); //możemy to zrobić nawet jeśli wysk.powiadomienia nie ma dzieki odpowiedniej konstrukcji metody.

            //aktualizacja badge'a
            ApplicationDataContainer ustawieniaLokalne = ApplicationData.Current.LocalSettings;
            if (ustawieniaLokalne.Values.ContainsKey("liczbaSpotkan"))
            {
                int liczbaSpotkan = (int)ustawieniaLokalne.Values["liczbaSpotkan"] - 1;
                ustawieniaLokalne.Values["liczbaSpotkan"] = liczbaSpotkan;
                powiadomienia.DodajWskaznikZNumerem(liczbaSpotkan);
            }

            //aktualizacja stron kafelka
            AktualizujStronyKafelkaAplikacji();

            OperacjeBazy.UsunSpotkanie(ObecneSpotkanie.ID);
            this.Frame.Navigate(typeof(MainPage));
        }

        private async void UsunPunktAgendy_Tapped(object sender, TappedRoutedEventArgs e)
        {
            if (gvPunktyAgendy.SelectedItem != null)
            {
                OperacjeBazy.UsunPunktAgendy(((PunktAgendy)(gvPunktyAgendy.SelectedItem)).ID);
                PunktyAgendy = await OperacjeBazy.PobierzPunktyAgendy(ObecneSpotkanie.ID);
                AgendaLista.Source = PunktyAgendy;

                gvPunktyAgendy.SelectedItem = null;
            }
            else
            {
                MessageDialog md = new MessageDialog("Punkt agendy nie został zaznaczony.");
                await md.ShowAsync();
            }

        }

        private void DodajPunktAgendy_Tapped(object sender, TappedRoutedEventArgs e)
        {

            popNowyPunkt.IsOpen = true;
        }

        private async void GridView_Tapped_1(object sender, TappedRoutedEventArgs e)
        {
            PunktAgendy punktAgendy = (PunktAgendy)gvPunktyAgendy.SelectedItem;

            if (punktAgendy.Wykonane)
                OperacjeBazy.EdytujPunktAgendy(new PunktAgendy { IDSpotkania = punktAgendy.IDSpotkania, Nazwa = punktAgendy.Nazwa, Wykonane = false, ID = punktAgendy.ID });
            else
                OperacjeBazy.EdytujPunktAgendy(new PunktAgendy { IDSpotkania = punktAgendy.IDSpotkania, Nazwa = punktAgendy.Nazwa, Wykonane = true, ID = punktAgendy.ID });

            PunktyAgendy = await OperacjeBazy.PobierzPunktyAgendy(ObecneSpotkanie.ID);
            AgendaLista.Source = PunktyAgendy;

            gvPunktyAgendy.SelectedItem = null;
        }

        /// <summary>
        /// Metoda dodająca punkty agendy
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private async void Button_Tapped_1(object sender, TappedRoutedEventArgs e)
        {
            grdJakDodacPunkt.Visibility = Visibility.Collapsed;
            gvPunktyAgendy.Visibility = Visibility.Visible;

            PunktAgendy punktAgendy = new PunktAgendy 
            { 
                Nazwa = txtPunktAgendy.Text, 
                IDSpotkania = ObecneSpotkanie.ID, 
                Wykonane = false 
            };

            OperacjeBazy.DodajPunktAgendy(punktAgendy);
            popNowyPunkt.IsOpen = false;

            PunktyAgendy = await OperacjeBazy.PobierzPunktyAgendy(ObecneSpotkanie.ID);
            AgendaLista.Source = PunktyAgendy;
            
            txtPunktAgendy.Text = "Punkt agendy";

            gvPunktyAgendy.SelectedItem = null;
        }


        private async void btnDodajDoKalendarza_Tapped(object sender, TappedRoutedEventArgs e)
        {
            if (App.polaczenieKlienta != null && App.polaczenieKlienta.Session != null)
            {
                DateTime koniec = dtKoniec.SelectedDate ?? new DateTime();
                DateTime start = dtPoczatek.SelectedDate ?? new DateTime();
                if (start != new DateTime() && koniec != new DateTime())
                {
                    SD = new SkyDrive(App.polaczenieKlienta);
                    if (ObecneSpotkanie.SkydriveIDKalendarza != null)
                        {
                            SD.UsunObiektNaSD(ObecneSpotkanie.SkydriveIDKalendarza);
                        }
                    ObecneSpotkanie.SkydriveIDKalendarza = await SD.DodajWydarzenieDoKalendarza(txtNazwa.Text, txtNotatka.Text, start, koniec, txtAdres.Text);
                    if (ObecneSpotkanie.SkydriveIDKalendarza != "")
                    {
                        MessageDialog md = new MessageDialog("Spotkanie zostało dodane do kalendarza");
                        await md.ShowAsync();
                    }
                }
            }
        }

        private void btnPrzypnijKafelekPomocniczy_Tapped(object sender, TappedRoutedEventArgs e)
        {
            powiadomienia.DodajKafelekPomocniczy(txtNazwa.Text, txtNotatka.Text, ObecneSpotkanie.ID.ToString(), ObecneSpotkanie.ID, sender);
        }
          
        /// <summary>
        /// Metoda wywołująca ekran robienia zdjęcia oraz zapisująca je na dusku lokalnym i SkyDrive
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private async void ZrobZdjecie(object sender, TappedRoutedEventArgs e)
        {
            CameraCaptureUI dialog = new CameraCaptureUI();
            Size aspectRatio = new Size(4,3);
            dialog.PhotoSettings.CroppedAspectRatio = aspectRatio;

            StorageFile file = await dialog.CaptureFileAsync(CameraCaptureUIMode.Photo);
            if (file != null)
            {
                BitmapImage bitmapImage = new BitmapImage();
                using (IRandomAccessStream fileStream = await file.OpenAsync(FileAccessMode.Read))
                {
                    bitmapImage.SetSource(fileStream);
                }

                imgPotwierdzenie.Source = bitmapImage;

                ImageUri = file.Path;

                if (App.polaczenieKlienta != null && App.polaczenieKlienta.Session != null && file != null)
                {
                   SD = new SkyDrive(App.polaczenieKlienta);
                   ObecneSpotkanie.SkydriveIDZdjecia = await SD.WyslijZdjecie(file, "MojeSpotkania_" + txtNazwa.Text + ".jpg");                    
                }
            }
        }

   
    }
}
