﻿package {
	
	import flash.display.MovieClip;
	import flash.desktop.NativeApplication;
	import flash.desktop.SystemIdleMode;
	import flash.events.Event;
	import flash.ui.Multitouch;
	import flash.ui.MultitouchInputMode;
	import flash.events.TouchEvent;
	
	public class Main extends MovieClip {
		
		private var application:NativeApplication;
		private var bubbles    :Array;
		private var speeds     :Array;
		
		public function Main() {
			Multitouch.inputMode = MultitouchInputMode.TOUCH_POINT;
			stage.addEventListener(TouchEvent.TOUCH_BEGIN, touchBegin);
			stage.addEventListener(TouchEvent.TOUCH_END, touchEnd);
			
			application = NativeApplication.nativeApplication;
			application.systemIdleMode = SystemIdleMode.KEEP_AWAKE;
			application.addEventListener(Event.EXITING, exiting);
			
			bubbles = [bubble1, bubble2, bubble3, bubble4, bubble5, bubble6, bubble7, bubble8, bubble9];
			speeds  = [1.3, 1.5, 1.8, 2, 2.2, 2.4, 4.5, 5, 8];
			
			for(var i:uint = 0; i < bubbles.length; i++)
			{
				bubbles[i].speed = speeds[i];
			}
			
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function exiting(e:Event):void {
			application.removeEventListener(Event.EXITING, exiting);
			application.systemIdleMode = SystemIdleMode.NORMAL;
			removeEventListener(Event.ENTER_FRAME, update);
		}
		
		private function touchBegin(e:TouchEvent):void {
			var b:Bubble = e.target as Bubble;
			if(b != null )
			{
				b.held = true;
			}
		}
		
		private function touchEnd(e:TouchEvent):void {
			var b:Bubble = e.target as Bubble;
			if(b != null)
			{
				b.held = false;
			}
		}
		
		private function update(e:Event):void {
			for each(var b:Bubble in bubbles)
			{
				b.update();
			}
		}
	}
}
