﻿package {
	
	import flash.display.Loader;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MediaEvent;
	import flash.events.MouseEvent;
	import flash.media.CameraRoll;
	import flash.media.MediaPromise;
		
	public class Main extends MovieClip {
		
		private var cameraRoll:CameraRoll;
		private var loader    :Loader;
		
		public function Main() {
			cameraRoll = new CameraRoll();
			cameraRoll.addEventListener(MediaEvent.SELECT, photoSelected);
			cameraRoll.addEventListener(Event.CANCEL, cancelled);
			
			browseBtn.addEventListener(MouseEvent.MOUSE_UP, buttonPressed);
		}
		
		private function buttonPressed(e:MouseEvent):void {
			browseBtn.visible = false;
			if(CameraRoll.supportsBrowseForImage)
			{
				cameraRoll.browseForImage();
			}
		}
		
		private function photoSelected(e:MediaEvent):void {
			var photoPromise:MediaPromise = e.data;
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, photoLoaded);
			loader.loadFilePromise(photoPromise);
		}
		
		private function cancelled(e:Event):void {
			browseBtn.visible = true;
		}
		
		private function photoLoaded(e:Event):void {
			var mc:Loader = e.currentTarget.loader as Loader;
			var scale:Number;
			if(mc.width > mc.height)
			{
				scale = stage.stageHeight / mc.width;
				mc.scaleX = scale;
				mc.scaleY = scale;
				mc.x = stage.stageWidth;
				mc.rotation = 90;
				addChild(mc);
			}
			else
			{
				scale = stage.stageWidth / mc.width;
				mc.scaleX = scale;
				mc.scaleY = scale;
				addChild(mc);
			}
		}
	}
}
