﻿package {
	
	import flash.desktop.NativeApplication;
	import flash.desktop.SystemIdleMode;
	import flash.display.MovieClip;
	import flash.geom.Rectangle;
	import flash.media.StageVideo;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	import flash.events.MouseEvent;
	import flash.events.NetStatusEvent;
	
	public class Main extends MovieClip {
		
		static private const VIDEO_URL:String = "video.mp4";
		
		private var netConnection:NetConnection;
		private var netStream:NetStream;
		private var video:StageVideo;
		
		public function Main() {
			NativeApplication.nativeApplication.systemIdleMode = SystemIdleMode.KEEP_AWAKE;

			netConnection = new NetConnection();
			netConnection.connect(null);
				
			netStream = new NetStream(netConnection);
			netStream.client = this;
			netStream.addEventListener(NetStatusEvent.NET_STATUS, statusUpdated);
			
			video = stage.stageVideos[0];
			video.attachNetStream(netStream);
			video.viewPort = new Rectangle(0, 25, 480, 270);
			
			setupControls();
		}
		
		public function onMetaData(dataObj:Object):void {
			;
		}
		
		private function statusUpdated(e:NetStatusEvent):void {
			if(e.info.code == "NetStream.Play.Stop")
			{
				showBtns(["playBtn"]);
			}
		}
		
		private function setupControls():void {
			controls.playBtn.addEventListener(MouseEvent.MOUSE_UP, playVideo);
			controls.restartBtn.addEventListener(MouseEvent.MOUSE_UP, restartVideo);
			controls.resumeBtn.addEventListener(MouseEvent.MOUSE_UP, resumeVideo);
			stage.addEventListener(MouseEvent.MOUSE_UP, pauseVideo);
			
			showBtns(["playBtn"]);
		}
		
		private function playVideo(e:MouseEvent):void {
			netStream.play(VIDEO_URL);
			hideBtns();
			e.stopPropagation();
		}
		
		private function pauseVideo(e:MouseEvent):void {
			if(controls.visible == false)
			{
				netStream.pause();
				showBtns(["resumeBtn", "restartBtn"]);
			}
		}
		
		private function restartVideo(e:MouseEvent):void {
			netStream.seek(0);
			netStream.resume();
			hideBtns();
			e.stopPropagation();
		}
		
		private function resumeVideo(e:MouseEvent):void {
			netStream.resume();
			hideBtns();
			e.stopPropagation();
		}
		
		private function hideBtns():void {
			controls.visible = false;
			blocker.visible = false;
		}
		
		private function showBtns(btns:Array):void {
			controls.visible = true;
			blocker.visible = true;
			for(var instName:String in controls)
			{
				if(btns.indexOf(instName) != -1)
				{
					controls[instName].visible = true;
				}
				else
				{
					controls[instName].visible = false;
				}
			}
		}
	}
}
