﻿package {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	
	public class Main extends MovieClip {
		
		static private const GRID_W:uint = 2;
		static private const GRID_H:uint = 2;
		
		static private const FRAME_W:uint = 192;
		static private const FRAME_H:uint = 256;
		
		static private const MAX_FRAMES:uint = GRID_W * GRID_H;
		
		private var bitmaps:Array = [];
		private var monkey:Bitmap = new Bitmap();
		private var frame:uint = 0;

		
		public function Main() {
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, bitmapLoaded);
			loader.load(new URLRequest("sprite-sheet.png"));
		}
		
		private function bitmapLoaded(e:Event):void {
			sliceSpriteSheet(e.target.content.bitmapData);
			createMonkey();
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function sliceSpriteSheet(sheet:BitmapData):void {
			for(var y:uint = 0; y < GRID_H; y++)
			{
				for(var x:uint = 0; x < GRID_W; x++)
				{
					var bd:BitmapData = new BitmapData(FRAME_W, FRAME_H, true);
					var srcRect:Rectangle = new Rectangle(
						(x * FRAME_W), (y * FRAME_H), FRAME_W, FRAME_H);
					bd.copyPixels(sheet, srcRect, new Point(0, 0));
					
					bitmaps.push(bd);
				}
			}
			
			sheet.dispose();
		}
		
		private function createMonkey():void {
			monkey = new Bitmap(bitmaps[0]);
			monkey.x = 64;
			monkey.y = 112;
			
			addChild(monkey);
		}
		
		private function update(e:Event):void {
			monkey.bitmapData = bitmaps[frame];
			if(++frame == MAX_FRAMES)
			{
				frame = 0;
			}
		}
	}
}
