﻿package {
	
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.SampleDataEvent;
	import flash.media.Microphone;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.utils.ByteArray;
	
	import flash.media.SoundCodec;
	
	public class Main extends MovieClip {
				
		private var mic      :Microphone;
		private var soundData:ByteArray;
		private var sound    :Sound;
		private var channel  :SoundChannel;
		
		public function Main() {
			micStatus.gotoAndStop(1);
			recordBtn.visible = true;
			stopBtn.visible = false;
			recordBtn.addEventListener(MouseEvent.MOUSE_UP, pressedRecordBtn);
			stopBtn.addEventListener(MouseEvent.MOUSE_UP, pressedStopBtn);
			
			mic = Microphone.getMicrophone();
			if(!Microphone.isSupported || mic == null)
			{
				recordBtn.visible = false;
			}
		}
		
		private function pressedRecordBtn(e:MouseEvent):void {
			startRecording();
		}
		
		private function pressedStopBtn(e:MouseEvent):void {
			stopRecording();
		}
		
		private function startRecording():void {
			micStatus.gotoAndStop(2);
			recordBtn.visible = false;
			stopBtn.visible = true;
			
			soundData = new ByteArray();
			mic.gain = 100;
			mic.rate = 44;
			mic.setSilenceLevel(0);
			mic.addEventListener(SampleDataEvent.SAMPLE_DATA, sampleData);
		}
		
		private function sampleData(e:SampleDataEvent):void {
			while(e.data.bytesAvailable)
			{
				var sample:Number = e.data.readFloat();
				soundData.writeFloat(sample);
			}
			
			if(soundData.length > 2097152)
			{
				stopRecording();
			}
		}
		
		private function stopRecording():void {
			micStatus.gotoAndStop(1);
			stopBtn.visible = false;
			mic.removeEventListener(SampleDataEvent.SAMPLE_DATA, sampleData);
			playRecording();
		}
		
		private function playRecording():void {			
			soundData.position = 0;
			
			sound = new Sound();
			sound.addEventListener(SampleDataEvent.SAMPLE_DATA, playSampleData);
			
			channel = sound.play();
			channel.addEventListener(Event.SOUND_COMPLETE, playbackComplete);
		}
		
		private function playSampleData(e:SampleDataEvent):void {
			for(var i:int = 0; i < 8192 && soundData.bytesAvailable > 0; i++)
			{
				var sample:Number = soundData.readFloat();
				e.data.writeFloat(sample);
				e.data.writeFloat(sample);
			}
		}
		
		private function playbackComplete(e:Event):void {
			recordBtn.visible = true;
			stopBtn.visible = false;
		}
	}
}
