﻿package {
	
	import flash.display.MovieClip;
	import flash.display.StageScaleMode;
	import flash.display.StageQuality;
	import flash.desktop.NativeApplication;
	import flash.desktop.SystemIdleMode;
	import flash.events.Event;
	
	public class Main extends MovieClip {
		
		private var bubbles    :Array;
		private var speeds     :Array;
		private var application:NativeApplication;
		
		public function Main() {
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.quality = StageQuality.BEST;
			
			application = NativeApplication.nativeApplication;
			application.systemIdleMode = SystemIdleMode.KEEP_AWAKE;
			application.addEventListener(Event.ACTIVATE, activate);
			application.addEventListener(Event.DEACTIVATE, deactivate);
			application.addEventListener(Event.EXITING, exiting);
			
			bubbles = [bubble1, bubble2, bubble3, bubble4, bubble5, bubble6, bubble7, bubble8, bubble9];
			speeds  = [1.3,     1.5,     1.8,     2,       2.2,     2.4,     4.5,     5,       8      ];
			for(var i:uint = 0; i < bubbles.length; i++)
			{
				bubbles[i].speed = speeds[i];
			}
		}
		
		private function exiting(e:Event):void {
			application.removeEventListener(Event.ACTIVATE, activate);
			application.removeEventListener(Event.DEACTIVATE, deactivate);
			application.removeEventListener(Event.EXITING, exiting);
			application.systemIdleMode = SystemIdleMode.NORMAL;
			removeEventListener(Event.ENTER_FRAME, update);
		}
		
		private function deactivate(e:Event):void {
			application.systemIdleMode = SystemIdleMode.NORMAL;
			removeEventListener(Event.ENTER_FRAME, update);
		}
		
		private function activate(e:Event):void {
			application.systemIdleMode = SystemIdleMode.KEEP_AWAKE;
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void {
			for each(var b:Bubble in bubbles)
			{
				b.update();
			}
		}
	}
}
