from django.db import models


class Project(models.Model):
    name = models.CharField(max_length=50, help_text="Nazwa projektu")
    creation_time = models.DateTimeField(auto_now_add=True, help_text="Czas utworzenia projektu.")
    completion_time = models.DateTimeField(null=True, help_text="Czas zakończenia projektu")

    def __str__(self):
        return self.name


class Task(models.Model):
    title = models.CharField(max_length=100,
                             help_text="Task title")
    description = models.TextField(help_text="Opis zadania")
    project = models.ForeignKey(Project, on_delete=models.CASCADE)
    time_estimate = models.IntegerField(help_text="Czas w godzinach potrzebny do wykonania zadania.")
    completed = models.BooleanField(default=False, help_text="Stan ukończenia projektu")

    def __str__(self):
        return self.title