from llama_index.core.postprocessor import SimilarityPostprocessor
from llama_index.core import VectorStoreIndex, SimpleDirectoryReader

reader = SimpleDirectoryReader('pliki/inne')
documents = reader.load_data()
index = VectorStoreIndex.from_documents(documents)
retriever = index.as_retriever(retriever_mode='default')
nodes = retriever.retrieve(
    "Co znalazł Fluffy w spokojnym strumyku?"
)

print('Początkowe węzły:')
for node in nodes:
    print(f"Węzeł: {node.node_id} - Wynik: {node.score}")

pp = SimilarityPostprocessor(
    nodes=nodes, 
    similarity_cutoff=0.76
)

remaining_nodes = pp.postprocess_nodes(nodes)
print('Istotne węzły:')
for node in remaining_nodes:
    print(f"Węzeł: {node.node_id} - Wynik: {node.score}")
