from llama_index.core import SummaryIndex, SimpleDirectoryReader
from llama_index.core import PromptTemplate

documents = SimpleDirectoryReader("pliki").load_data()
summary_index = SummaryIndex.from_documents(documents)
qe = summary_index.as_query_engine()
print(qe.query("Kto spalił Rzym?"))
print("------------------------")

new_qa_template = (
"Kontekst jest podany poniżej."
"---------------------"
"{context_str}"
"---------------------"
"Biorąc pod uwagę kontekst "
"i swoją wcześniejszą wiedzę, "
"odpowiedz na pytanie."
"Pytanie: {query_str}"
"Odpowiedź:")

template = PromptTemplate(new_qa_template)

qe.update_prompts(
    {"response_synthesizer:text_qa_template": template}
)
print(qe.query("Kto spalił Rzym?"))