import asyncio
from llama_index.core import KeywordTableIndex
from llama_index.core import SimpleDirectoryReader

async def retrieve(retriever, query, label):
    response = await retriever.aretrieve(query)
    print(f"{label} wyszukał {str(len(response))} węzłów")

async def main():
    reader = SimpleDirectoryReader('pliki')
    documents = reader.load_data()
    index = KeywordTableIndex.from_documents(documents)
    retriever1 = index.as_retriever(
retriever_mode='default'
)
    retriever2 = index.as_retriever(
retriever_mode='simple'
)
    query = "Gdzie znajduje się Koloseum?"

    await asyncio.gather(
        retrieve(retriever1, query, '<llm>'),
        retrieve(retriever2, query, '<simple>')
    )
asyncio.run(main())
