from llama_index.core.postprocessor import MetadataReplacementPostProcessor
from llama_index.core.schema import TextNode, NodeWithScore

nodes = [
    TextNode(
        text="Artykuł 1", 
        metadata={"summary": "Streszczenie artykułu 1"}
    ),
    TextNode(
        text="Artykuł 2", 
        metadata={"summary": "Streszczenie artykułu 2"}
    ),
]

node_with_score_list = [
    NodeWithScore(node=node) for node in nodes
]
pp = MetadataReplacementPostProcessor(
    target_metadata_key="summary"
)
processed_nodes = pp.postprocess_nodes(
    node_with_score_list
)
for node_with_score in processed_nodes:
    print(f"Zastąpiony tekst: {node_with_score.node.text}")
