-- Listing 5.1

CREATE PROCEDURE Person.GetEmployee
(
    @BusinessEntityID int = NULL
  , @Email_Address nvarchar(50) OUTPUT
  , @Full_Name nvarchar(100) OUTPUT
)
AS

BEGIN

    -- Pobranie adresw e-mail i nazwisk z tabeli HumanResources.Employee 
    SELECT @Email_Address = ea.EmailAddress,
      @Full_Name = p.FirstName + ' ' + COALESCE(p.MiddleName,'') + ' ' + p.LastName
    FROM HumanResources.Employee e
    INNER JOIN Person.Person p
      ON e.BusinessEntityID = p.BusinessEntityID
    INNER JOIN Person.EmailAddress ea
      ON p.BusinessEntityID = ea.BusinessEntityID
    WHERE e.BusinessEntityID = @BusinessEntityID;

    -- Zwraca 1, jeli nie znajdzie dopasowania, 0 przy dopasowaniu 
    RETURN (
      CASE
      WHEN @Email_Address IS NULL THEN 1
      ELSE 0
      END
    );
END;
GO
