-- Listing 4.10

USE [AdventureWorks2014]
GO

IF EXISTS (SELECT * FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[dbo].[Liczby]')
      AND type in (N'U'))
DROP TABLE [dbo].[Liczby];

-- Tworzy tabel z liczbami pozwalajc na zbudowanie listy produktw za pomoc operacji na zbiorach 
CREATE TABLE dbo.Liczby (Num int NOT NULL PRIMARY KEY);
GO
-- Wypenij tabel liczbami od 0 do 30000
WITH NumCTE (Num)
AS
(
SELECT 0

UNION ALL

SELECT Num + 1
FROM NumCTE
WHERE Num < 30000
)

INSERT INTO dbo.Liczby (Num) SELECT Num FROM NumCTE
OPTION (MAXRECURSION 0);
GO

