-- Listing 1.7

CREATE PROCEDURE dbo.GetOrAdd_ContactType 
(
    @Name NVARCHAR(50),
    @ContactTypeID INT OUTPUT 
) 
AS
    DECLARE @Err_Code AS INT;

    SELECT @Err_Code = 0;

    SELECT @ContactTypeID = ContactTypeID 
    FROM Person.ContactType 
    WHERE [Name] = @Name;

    IF @ContactTypeID IS NOT NULL
    RETURN;	-- Wyjcie 1: jeli ContactType istnieje

    INSERT
    INTO Person.ContactType ([Name], ModifiedDate)
    SELECT @Name, CURRENT_TIMESTAMP;

    SELECT @Err_Code = 'error'; 
    IF @Err_Code <> 0
       RETURN @Err_Code;  -- Wyjcie 2: przy bdzie podczas wykonywania INSERT

    SELECT @ContactTypeID = SCOPE_IDENTITY();

    RETURN @Err_Code;     -- Wyjcie 3: po udanym wykonaniu INSERT 
GO
