-- Listing 8.14

-- Utwrz tymczasow tabel na wyniki.
CREATE TABLE #TempNames
(
  BusinessEntityID int PRIMARY KEY,
  FirstName nvarchar(50),
  MiddleName nvarchar(50),
  LastName nvarchar(50),
  EncFirstName varbinary(200),
  EncMiddleName varbinary(200),
  EncLastName varbinary(200)
);

-- Utwrz DMK.
CREATE MASTER KEY
ENCRYPTION BY PASSWORD = 'Test_P@sswOrd';

-- Utwrz certyfikat do zabezpieczenia klucza symetrycznego.
CREATE CERTIFICATE TestCertificate
WITH SUBJECT = 'Certyfikat testowy AdventureWorks',
EXPIRY_DATE = '2026-10-31';

-- Utwrz klucz symetryczny do szyfrowania danych.
CREATE SYMMETRIC KEY TestSymmetricKey
WITH ALGORITHM = AES_128
ENCRYPTION BY CERTIFICATE TestCertificate;

-- Otwrz klucz symetryczny.
OPEN SYMMETRIC KEY TestSymmetricKey
DECRYPTION BY CERTIFICATE TestCertificate;

-- Wstaw do tabeli tymczasowej 100 zaszyfrowanych nazwisk z tabeli Person.Person. 
INSERT
INTO #TempNames
(
BusinessEntityID,
EncFirstName,
EncMiddleName,
EncLastName
)
SELECT TOP(100) BusinessEntityID,
EncryptByKey(Key_GUID(N'TestSymmetricKey'), FirstName),
EncryptByKey(Key_GUID(N'TestSymmetricKey'), MiddleName),
EncryptByKey(Key_GUID(N'TestSymmetricKey'), LastName)
FROM Person.Person
ORDER BY BusinessEntityID;

-- Uzupenij tabel tymczasow rozszyfrowanymi nazwiskami. 
UPDATE #TempNames
SET FirstName = DecryptByKey(EncFirstName),
MiddleName = DecryptByKey(EncMiddleName),
LastName = DecryptByKey(EncLastName);

-- Wywietl wyniki. 
SELECT BusinessEntityID,
FirstName,
MiddleName,
LastName,
EncFirstName,
EncMiddleName,
EncLastName
FROM #TempNames;

-- Zamknij klucz symetryczny.
CLOSE SYMMETRIC KEY TestSymmetricKey;

-- Usu klucz symetryczny.
DROP SYMMETRIC KEY TestSymmetricKey;

-- Usu certyfikat.
DROP CERTIFICATE TestCertificate;

-- Usu DMK.
DROP MASTER KEY;

-- Usu tabel tymczasow.
DROP TABLE #TempNames;
