USE wydawnictwo
CREATE TABLE kraj
  (id_kraju int IDENTITY
  CONSTRAINT pk_kr PRIMARY KEY,
  kraj varchar (20) NOT NULL UNIQUE,
  uwagi varchar(250),
  )
CREATE TABLE osoba
  (id_osoby int IDENTITY
  CONSTRAINT pk_o PRIMARY KEY,
  imie varchar (20) NOT NULL,
  nazwisko varchar (25) NOT NULL,
  telefon varchar (15),
   e_mail varchar (40)
  CONSTRAINT ch_o_m CHECK (LEN(e_mail)-LEN(REPLACE(e_mail,'@',''))>0),
  prezes bit DEFAULT 0,
  uwagi varchar(250),
  )
GO
CREATE TABLE wydawnictwo
  (id_wydawnictwa uniqueidentifier DEFAULT NEWID()
  CONSTRAINT pk_w PRIMARY KEY NONCLUSTERED,
  nazwa varchar (40) NOT NULL,
  kod char (6),
  ulica_nr_domu varchar (50),
  telefon varchar (15),
   e_mail varchar (40)
  CONSTRAINT ch_w_m CHECK (LEN(e_mail)-LEN(REPLACE(e_mail,'@',''))>0),
  bank varchar (40),
  konto varchar (30),
  id_miasta int REFERENCES miasto(id_miasta)
  ON UPDATE CASCADE ON DELETE NO ACTION,
  id_kraju int REFERENCES kraj(id_kraju)
  ON UPDATE CASCADE ON DELETE NO ACTION,
  id_osoby int REFERENCES osoba(id_osoby)
  ON UPDATE NO ACTION ON DELETE NO ACTION,
  id_prezesa int REFERENCES  osoba(id_osoby)
  ON UPDATE NO ACTION  ON DELETE NO ACTION,
  uwagi varchar(250),
  )
GO
