USE pubs
GO
CREATE FUNCTION fn_autorzy
(@dane tinyint)
RETURNS @fn_autorzy TABLE
  (id_autora varchar (40) PRIMARY KEY NOT NULL,
  autor varchar(60) NOT NULL,
  ksiazek smallint)
AS
BEGIN
IF @dane = 1 --minimalna liczba danych
  INSERT @fn_autorzy
    SELECT a.au_id, au_lname, COUNT (title_id)
    FROM dbo.authors a JOIN dbo.titleauthor t
      ON a.au_id = t.au_id
    GROUP BY a.au_id, au_lname
ELSE IF @dane = 2 --rednia liczba danych
  INSERT @fn_autorzy
    SELECT a.au_id, au_lname + ' ' + au_fname, COUNT (title_id)
    FROM dbo.authors a JOIN dbo.titleauthor t
      ON a.au_id = t.au_id
    GROUP BY a.au_id, au_lname + ' ' + au_fname
ELSE IF @dane = 3 --maksymalna liczba danych
  INSERT @fn_autorzy
    SELECT a.au_id, au_lname + ' ' + au_fname + ' ' + address, COUNT (title_id)
    FROM dbo.authors a JOIN dbo.titleauthor t
      ON a.au_id = t.au_id
    GROUP BY a.au_id, au_lname + ' ' + au_fname + ' ' + address
RETURN
END
GO
