# Plik ten jest konfigurowany za pomoc towarzyszcego pliku build.xml 
# narzdzia Ant. Jeli zamierza si zmieni wartoci zmiennych, naley
# to zrobi przez wywoanie polecenia ant procesu budowania (na przykad
# ant -Dpackage.name=to) lub ustawienie wartoci waciwoci w pliku
# waciwoci lub w samym pliku build.xml. Jeeli jednak dysponuje si tylko
# rdami pakietw RPM, wartoci mona zmieni w tym pliku.

# Nazwa tego pakietu RPM. Nazwa moe zosta nieznacznie zmieniona w czasie
# procesu budowania w celu umoliwienia jednoczesnego wygenerowania i 
# zainstalowania dla skadnika tego samego komputera wicej ni jednego pakietu
# (z wykorzystaniem jedynie rnych prefiksw instalacyjnych i identyfikatorw JVM_ID).
%define package_name @PACKAGE_NAME@

# Identyfikator maszyny JVM Tomcata, ktry powinien by przez ni uywany
# do identyfikowania. Identyfikator JVM_ID moe by dowoln nazw pod warunkiem,
# e nie zawiera spacji lub znakw cudzysowu bd innych specjalnych znakw
# powoki, takich jak |, >, !, $ lub &.
%define jvm_id @JVM_ID@

# Nazwa konta uytkownika wykorzystywanego do uruchomienia instancji Tomcata.
%define tomcat_user @TOMCAT_USER@

# Identyfikator konta uytkownika okrelonego w %{tomcat_username}.
%define tomcat_uid @TOMCAT_UID@

# Nazwa grupy, w ktrej znajdzie si uytkownik serwera Tomcat.
%define tomcat_group @TOMCAT_GROUP@

# Identyfikator grupy serwera Tomcat.
%define tomcat_gid @TOMCAT_GID@

# Domylny prefiks bezwzgldnej cieki systemu plikw, w ktrej s instalowane pliki.
%define default_install_prefix /opt/%{package_name}

# Poniszy wiersz jest wymagany do tego, eby pakiet RPM mg znale katalogi
# BUILD i SOURCES.
%define _topdir @TOP_DIR@

Summary: Kontener serwletw i stron JSP o nazwie Tomcat.
Name: %{package_name}
Version: @VERSION@
Release: @BUILD_SERIAL@
License: Apache License v2.0
Vendor: Jason Brittain
Group: Networking/Daemons
URL: http://www.webdroid.org
Source0: apache-tomcat-%{version}.tar.gz
Source3: %{package_name}-init.linux
Source4: %{package_name}-env.sh
Source5: server.xml
Source6: web.xml
Source7: tomcat-users.xml
Source8: logging.properties
Source9: ROOT.xml
BuildRoot: %{_topdir}/BUILD/%{package_name}
BuildArch: noarch
Prefix: %{default_install_prefix}
#Requires: # Wiersz naley tak zmodyfikowa, eby pakiet da pakietu RPM wybranej maszyny JVM.
Provides: %{package_name}

%description
Kontener serwletw i stron JSP o nazwie Tomcat implementuje specyfikacje
Java Servlet 2.5 i Java Server Pages (JSP) 2.1 firmy Sun Microsystems.

Ten dodatkowy kod tworzcy pakiet i skrypt uruchomieniowy oryginalnie
zosta napisany jako cz ksiki "Tomcat: The Definitive Guide, 2nd Edition",
autorstwa Jasona Brittaina i Iana Darwina. Kod objty jest t sam licencj
co serwer Tomcat, czyli Apache License w wersji 2.0.

$Id$

%prep
cd %{_topdir}/BUILD
rm -rf %{package_name}

# Rozpakowanie wczeniej utworzonych binariw serwera.
tar -zxf %{_topdir}/SOURCES/apache-tomcat-%{version}.tar.gz

# Sprawienie, eby cieki przypominay domylne cieki procesu wdraania pakietu.
mv apache-tomcat-%{version} %{package_name}

# Skopiowanie domylnego pliku server.xml do pliku o nazwie server.xml.stock.
cp %{package_name}/conf/server.xml %{package_name}/conf/server.xml.stock || :

# Skopiowanie niestandardowych plikw konfiguracyjnych do katalogu conf/.
cp %{_topdir}/SOURCES/server.xml %{_topdir}/SOURCES/web.xml \
    %{_topdir}/SOURCES/catalina.properties \
    %{_topdir}/SOURCES/tomcat-users.xml \
    %{_topdir}/SOURCES/logging.properties %{package_name}/conf/ || :

# Skopiowanie pliku ROOT.xml, jeli znajduje si w katalogu SOURCES. W przeciwnym razie
# plik jest pusty i zostanie usunity.
touch %{_topdir}/SOURCES/ROOT.xml
mkdir -p %{package_name}/conf/Catalina/localhost || :
cp %{_topdir}/SOURCES/ROOT.xml %{package_name}/conf/Catalina/localhost/ || :
if [ ! -s %{package_name}/conf/Catalina/localhost/ROOT.xml ]; then
    rm %{package_name}/conf/Catalina/localhost/ROOT.xml || :
fi

# Przeniesienie skryptw inicjalizacyjnych i konfiguracyjnych do odpowiednich
# katalogw.
cp %{_topdir}/SOURCES/%{package_name}-init.linux \
    %{package_name}/bin/%{package_name}
cp %{_topdir}/SOURCES/%{package_name}-env.sh %{package_name}/conf/

# Dodatkowe enkapsulowanie plikw serwera w ciece /opt/%{package_name}.
mkdir -p opt/
mv %{package_name} opt/
mkdir %{package_name}
mv opt %{package_name}/

# Utworzenie list dla podstawowych plikw serwera Tomcat.
find %{package_name} | cut -d'/' -f 2- | grep -xv %{package_name} \
    > .server-ant-files.txt || :
cat .server-ant-files.txt | xargs -i echo "/{}" >.server-files.txt || :

# Utworzenie ostatecznych list plikw. Kada lista wyklucza pliki innego pakietu.
cat .server-files.txt > .server.txt

# Zastosowanie wszelkich poprawek (aktualnie operacja nie jest wykonywana).
#pushd %{package_name}/opt/%{package_name}
#%patch0 -p0
#popd

# Ustawienie waciciela i grupy jako root, jeli proces budowania jest
# realizowany z jego uprawnieniami.
[ `id -u` = '0' ] && chown -Rhf root %{package_name}
[ `id -u` = '0' ] && chgrp -Rhf root %{package_name}
chmod -Rf a+rX,g-w,o-w %{package_name}

# Ustawienie specjalnie wybranych uprawnie.
chmod 755 %{package_name}%{default_install_prefix}/bin
chmod 750 %{package_name}%{default_install_prefix}/bin/*.sh
chmod 750 %{package_name}%{default_install_prefix}/bin/%{package_name}
chmod 750 %{package_name}%{default_install_prefix}/conf
chmod 750 %{package_name}%{default_install_prefix}/conf/Catalina
chmod 775 %{package_name}%{default_install_prefix}/temp
chmod 770 %{package_name}%{default_install_prefix}/webapps
chmod 775 %{package_name}%{default_install_prefix}/work

%build

%install

%clean

%pre
# Ustawienie kilku wymaganych zmiennych.
if [ $1 = 2 ]; then
    # Pakiet jest aktualizowany (rpm -U) lub ponownie instalowany (rpm -U --force).

    # Stwierdzenie przed aktualizacj, jaki jest prefiks ju zainstalowanego pakietu.
    BEFORE_PREFIX="`rpm -q --queryformat '%{INSTALLPREFIX}' %{package_name}`"

    # Jeli pakiet umieszcza si w miejscu identyfikowanym przez nowy prefiks,
    # a nie w lokalizacji pakietu umoliwiajcego aktualizacj,
    # wystarczy usun pliki moliwe do sprawdzenia i oprni katalogi ju
    # zainstalowanego pakietu, eby dane mona byo zapisa w pooeniu 
    # okrelonym przez nowy prefiks.
    if [ "$BEFORE_PREFIX" != "$RPM_INSTALL_PREFIX" ]; then
        # Uzyskanie listy plikw, ktrych nie mona sprawdzi.
        NON_VERIFIABLES="`rpm -V %{package_name} | cut -c 13-`"

        # Wykonanie ptli dla kadej cieki pliku ju zainstalowanego pakietu.
        for pathname in `rpm -ql %{package_name}`; do
            if [ -d "$pathname" ] ; then
                # Poniewa jest to katalog, naley go usun wraz z jego 
                # katalogiem nadrzdnym (jeli jest pusty).
                rmdir -p "$pathname" >/dev/null 2>&1
            else
                # Poniewa nie jest to katalog, naley podj prb  usunicia.
                echo -e $NON_VERIFIABLES | grep -x "$pathname" >/dev/null 2>&1
                if [ $? == 1 ]; then
                    # Poniewa obiekt jest moliwy do sprawdzenia, 
                    # mona go bez obaw usun.
                    rm "$pathname" >/dev/null 2>&1

                    # Jeli po usuniciu pliku jego katalog pozostanie pusty,
                    # naley sprbowa usun ten katalog, a take jego puste
                    # katalogi nadrzdne.
                    rmdir -p "`dirname $pathname`" >/dev/null 2>&1
                fi
            fi
        done
    fi
fi

# Dodanie konta uytkownika Tomcata, jeli jeszcze nie istnieje.
TOMCAT_SHELL="/sbin/nologin"
if [ ! -x /etc/rc.d/init.d/functions -o ! -x /sbin/runuser ]; then
    # W celu uruchomienia Tomcata z uprawnieniami uytkownika TOMCAT_USER
    # trzeba bdzie uy narzdzia su. W zwizku z tym uytkownik ten musi
    # dysponowa poprawn powok logowania.
    %{_sbindir}/usermod -s /bin/bash %{tomcat_user} 2>/dev/null || :
    TOMCAT_SHELL="/bin/bash"
fi

# Dodanie grupy serwera Tomcat, jeli jeszcze ona nie istnieje.
TOMCAT_GROUP_ID="`egrep '^%{tomcat_group}:' /etc/group | cut -d':' -f 3`" \
    2>/dev/null || :
if [ "$TOMCAT_GROUP_ID" == "" ]; then
    %{_sbindir}/groupadd -g %{tomcat_gid} %{tomcat_group} 2>/dev/null || :
    # Jeli wystpi bd podczas dodawania grupy o okrelonym identyfikatorze,
    # grup naley doczy bez podawania jej identyfikatora (w przeciwnym razie
    # bd generowane bdy).
    if [ $? == 1 ]; then
        %{_sbindir}/groupadd %{tomcat_group} 2>/dev/null || :
    fi
fi
# Uzyskanie identyfikatora grupy serwera Tomcat
TOMCAT_GROUP_ID="`egrep '^%{tomcat_group}:' /etc/group | cut -d':' -f 3`" \
    2>/dev/null || :

# Dodanie uytkownika serwera Tomcat, jeli jeszcze nie istnieje.
id %{tomcat_user} &>/dev/null
if [ $? == 1 ]; then
    %{_sbindir}/useradd -c "Uytkownik maszyny JVM Tomcata." -g $TOMCAT_GROUP_ID \
        -s $TOMCAT_SHELL -r -M -d $RPM_INSTALL_PREFIX/temp \
        -u %{tomcat_uid} %{tomcat_user} 2>/dev/null || :
    # Prba zablokowania hasa uytkownika.
    passwd -l %{tomcat_user} &>/dev/null || :
else
    # Jeli konto uytkownika ju istnieje, raczej nie powinno si go zmienia.
    # Jednak w sytuacji, gdy Tomcat nie uruchomi si, naley zmodyfikowa konto.
    if [ TOMCAT_SHELL == "/bin/bash" ]; then
        usermod -s $TOMCAT_SHELL %{tomcat_user} || :
    fi

    TOMCAT_USER_DIR="`echo ~tomcat`"
    if [ "$TOMCAT_USER_DIR" == "/dev/null" ]; then
        usermod -d $RPM_INSTALL_PREFIX/temp tomcat
    fi
fi

%post
if [ "$SERVICE_NAME" == "" ]; then
    SERVICE_NAME="%{jvm_id}"
    if [ "$JVM_ID_SUFFIX" != "" ]; then
        SERVICE_NAME="%{jvm_id}-$JVM_ID_SUFFIX"
    fi
fi

# Utworzenie dla skryptu inicjalizacyjnego dowizania symbolicznego w 
# %{_sysconfdir}/init.d
rm -f %{_sysconfdir}/init.d/$SERVICE_NAME
ln -s $RPM_INSTALL_PREFIX/bin/%{package_name} \
    %{_sysconfdir}/init.d/$SERVICE_NAME

# Zastosowanie fragmentw konfiguracji logrotate.d.
#install -d -m 755 %{_sysconfdir}/logrotate.d
#if [ -f "%{_sysconfdir}/logrotate.d/$SERVICE_NAME" ]; then
#    rm -f %{_sysconfdir}/logrotate.d/$SERVICE_NAME || :
#fi
#rm -f %{_sysconfdir}/logrotate.d/$SERVICE_NAME.rpmsave || :
#install -m 644 $RPM_INSTALL_PREFIX/conf/%{package_name}.logrotate \
#    %{_sysconfdir}/logrotate.d/$SERVICE_NAME

# Zastpienie tokenw wartociami znajdujcymi si 
# w skryptach i plikach konfiguracyjnych.
for i in $RPM_INSTALL_PREFIX/bin/%{package_name} \
         $RPM_INSTALL_PREFIX/conf/%{package_name}-env.sh
do
    perl -pi -e "s|\@PKG_NAME\@|%{package_name}|g;" $i
    perl -pi -e "s|\@TOMCAT_USER\@|%{tomcat_user}|g;" $i
    perl -pi -e "s|\@PKG_ROOT\@|$RPM_INSTALL_PREFIX|g;" $i
    perl -pi -e "s|\@TOMCAT_DIR\@|$RPM_INSTALL_PREFIX|g;" $i
    perl -pi -e "s|\@JVM_ID\@|$SERVICE_NAME|g;" $i
done

# Dodanie usugi za porednictwem narzdzia chkconfig.
if [ -x /sbin/chkconfig ]; then
    # Poinformowanie systemu inicjalizacyjnego o skrypcie uaktywniajcym serwer
    # Tomcat i sprawdzenie, czy uruchamia si on podczas adowania systemu.
    /sbin/chkconfig --add $SERVICE_NAME || :

    # Wczenie usugi za pomoc narzdzia chkconfig,
    # lecz tylko w rodowisku produkcyjnym.
    if [ ! $DEV ]; then
        /sbin/chkconfig --level 2345 $SERVICE_NAME on || :
    else
        /sbin/chkconfig --level 2345 $SERVICE_NAME off || :
    fi
fi

# Utworzenie katalogu /var/log/$SERVICE_NAME. Bd w nim znajdowa si dzienniki.
# $CATALINA_BASE/logs bdzie dowizaniem symbolicznym do tego katalogu.
# Oznacza to, e dzienniki pozostan w obrbie partycji /var (jeli istnieje).
install -d -m 755 -o %{tomcat_user} -g %{tomcat_group} /var/log/$SERVICE_NAME

# Utworzenie dowizania symbolicznego midzy $CATALINA_BASE/logs
# i /var/log/$SERVICE_NAME. Jeli takowe ju istnieje, zostanie usunite,
# po czym nastpi utworzenie nowego dowizania.
if [ -h "$RPM_INSTALL_PREFIX/logs" ]; then
    # Poniewa jest to dowizanie symboliczne, naley je po prostu usun.
    rm -f $RPM_INSTALL_PREFIX/logs
fi

# Jeli dowizanie nadal istnieje i jest katalogiem, naley sprawdzi,
# czy mona go usun.
if [ -d "$RPM_INSTALL_PREFIX/logs" ]; then
    rmdir $RPM_INSTALL_PREFIX/logs >/dev/null 2>&1 || :
fi
if [ -e "$RPM_INSTALL_PREFIX/logs" ]; then
    # Poniewa prawdopodobnie jest to plik lub katalog, zostanie przeniesiony.
    mv $RPM_INSTALL_PREFIX/logs $RPM_INSTALL_PREFIX/logs.rpmsave || :
fi
ln -s /var/log/$SERVICE_NAME $RPM_INSTALL_PREFIX/logs || :

# W przypadku aktualizacji lub usuwania zawsze naley oprni katalog
# $CATALINA_BASE/work serwera Tomcat.
rm -rf $RPM_INSTALL_PREFIX/work/* || :

%preun
if [ "$SERVICE_NAME" == "" ]; then
    SERVICE_NAME="%{package_name}"
    if [ "$JVM_ID_SUFFIX" != "" ]; then
        SERVICE_NAME="%{package_name}-$JVM_ID_SUFFIX"
    fi
fi

# W przypadku aktualizacji lub usuwania zawsze naley oprni katalog
# CATALINA_BASE/work serwera Tomcat.
rm -rf $RPM_INSTALL_PREFIX/work/*

if [ $1 = 0 ]; then
    # Usuwanie pakietu (rpm -e).

    # Sprawdzenie, czy serwer zosta wyczony.
    %{_sysconfdir}/init.d/$SERVICE_NAME stop >/dev/null 2>&1

    # Jeli istnieje skrypt inicjalizacyjny, naley usun go za pomoc narzdzia
    # chkconfig.
    if [ -f %{_sysconfdir}/init.d/$SERVICE_NAME -a -x /sbin/chkconfig ]; then
        /sbin/chkconfig --del $SERVICE_NAME || :
    fi
fi

# Uytkownik Tomcata nie jest usuwany, gdy nadal moe by wacicielem wielu plikw.
# Mog to by na przykad pliki w katalogach dziennikw i katalogach roboczych.

%postun
if [ "$SERVICE_NAME" == "" ]; then
    SERVICE_NAME="%{jvm_id}"
    if [ "$JVM_ID_SUFFIX" != "" ]; then
        SERVICE_NAME="%{jvm_id}-$JVM_ID_SUFFIX"
    fi
fi

if [ $1 = 0 ]; then
    # Pakiet jest odinstalowywany (rpm -e).

    # Usuwanie skryptu inicjalizacyjnego.
    rm -f %{_sysconfdir}/init.d/$SERVICE_NAME || :

    # Usuwanie katalogu dziennikw, jeli zosta utworzony i nadal jest pusty.
    rmdir /var/log/$SERVICE_NAME >/dev/null 2>&1 || :
fi

%files -f .server.txt
# Domylny waciciel plikw i grupa dla plikw/katalogw pakietu.
%defattr(-,%{tomcat_user},%{tomcat_group},-)

# Wykluczenia.
# Wiersz powoduje, e narzdzie RPM nie uznaje gwnego pakietu za waciciela
# wykluczonych plikw i (lub) katalogw.
%exclude %dir /opt

# Pliki konfiguracyjne.
# Zdeklarowanie pliku jako %config(noreplace), jeli instalacja lub aktualizacja
# pakietu RPM nigdy nie ma nadpisa ju wdroonej kopii pliku.
%config %{prefix}/conf/*