#!/bin/sh
#
# Linuksowy skrypt init dla kontenera serwletw Apache Tomcat
# dziaajcego w obrbie klatki narzdzia chroot.
#
# chkconfig: 2345 96 14
# opis: kontener serwletw Apache Tomcat.
# nazwa procesu: tc-chroot
# konfiguracja: /opt/chroot/tomcat/conf/tomcat-env.sh
#
# $Id$
#
# Autor: Jason Brittain <jason.brittain@gmail.com>

APP_ENV="/opt/tomcat/conf/tomcat-env.sh"

# Okrelenie rdowej lokalizacji pliku konfiguracyjnego aplikacji (jeli istnieje).
[ -r "$APP_ENV" ] && . "${APP_ENV}"

# cieka skryptu uruchamiajcego i zatrzymujcego Tomcata.
TOMCAT_SCRIPT=$CATALINA_HOME/bin/catalina.sh

# Nazwa programu.
PROG="$0"

# Rozpoznanie dowiza - $0 moe by mikkim dowizaniem.
while [ -h "$PROG" ]; do
    ls=`ls -ld "$PROG"`
    link=`expr "$ls" : '.*-> \(.*\)$'`
    if expr "$link" : '.*/.*' > /dev/null; then
        PROG="$link"
    else
        PROG=`dirname "$PROG"`/"$link"
    fi
done

PROG="`basename $PROG`"

case "$1" in
  start)
        echo -n "Uruchamianie $PROG: "

        # Podczenie /proc.
        mkdir -p /opt/chroot/proc
        mount -t proc proc /opt/chroot/proc &>/dev/null

        chroot /opt/chroot /bin/bash -c "set -a; . $APP_ENV; \
            $TOMCAT_SCRIPT start" &>/dev/null

        let RETVAL=$?
        if [ $RETVAL -eq 0 ]; then
            echo "[  OK  ]"
        else
            echo "[  NIEPOWODZENIE  ]"
        fi
        ;;
  stop)
        echo -n "Zatrzymywanie $PROG: "

        chroot /opt/chroot /bin/bash -c "set -a; . $APP_ENV; \
            $TOMCAT_SCRIPT stop" &>/dev/null

        let RETVAL=$?
        if [ $RETVAL -eq 0 ]; then
            # Danie serwerowi Tomcat czasu na poprawne zatrzymanie wszystkich aplikacji WWW.
            sleep 3

            # Odczenie /proc.
            umount /opt/chroot/proc &>/dev/null
            echo "[  OK  ]"
        else
            echo "[  NIEPOWODZENIE  ]"
        fi
        ;;
  *)
        echo "Uycie: tc-chroot {start|stop}"
        exit 1
esac