/*      $OpenBSD: chroot.c,v 1.7 2002/10/29 23:12:06 millert Exp $        */
/*      $NetBSD: chroot.c,v 1.11 2001/04/06 02:34:04 lukem Exp $        */

/*
 * Prawa autorskie (c) 1988, 1993
 *      Wadze Uniwersytetu Kalifornijskiego.  Wszystkie prawa zastrzeone.
 *
 * Redystrybucja i wykorzystanie w postaci rdowej i formach binarnych, 
 * wraz lub bez modyfikacji s dozwolone przy spenieniu nastpujcych warunkw:
 * 1. Redystrybucja kodu rdowego musi zachowa wyej zamieszczon not o prawach
 *    autorskich, obecny wykaz warunkw i ponisze owiadczenie.
 * 2. Redystrybucja w formie binarnej musi zawiera wyej wymienion not o prawach
 *    autorskich, obecny wykaz warunkw i ponisze owiadczenie w dokumentacji i(lub)
 *    pozostaych materiaach dostarczonych wraz dystrybucj.
 * 3. Wszystkie materiay reklamowe wspominajce o funkcjach lub przeznaczeniu 
 *    tego oprogramowania musz zawiera nastpujce owiadczenie:
 *      Ten produkt zawiera oprogramowanie stworzone przez Uniwersytet 
 *      Kalifornijski w Berkeley i jego wsppracownikw.
 * 4. Bez wczeniejszej pisemnej zgody ani nazwa uniwersytetu ani personalia
 *    jego wsppracownikw nie mog by wykorzystane na potrzeby promowania
 *    produktw bazujcych na tym oprogramowaniu.
 *
 * OPROGRAMOWANIE TO JEST DOSTARCZONE PRZEZ UNIWERSYTET I WSPӣPRACOWNIKW ''BEZ 
 * GWARANCJI''. JAKAKOLWIEK ODPOWIEDZIALNO LUB GWARANCJA DOMNIEMANA, WCZAJC, 
 * ALE NIE OGRANICZAJC, DOMNIEMANEJ GWARANCJI SPRZEDAY I PRZYDATNOCI DO SPECYFICZNEGO
 * WYKORZYSTANIA S ZAPRZECZALNE. W ADNYM PRZYPADKU UNIWERSYTET LUB WSPӣPRACOWNICY NIE 
 * BD ODPOWIEDZIALNI ZA JAKKOLWIEK SZKOD BEZPOREDNI, POREDNI, INCYDENTALN, 
 * PRZYKADOW ORAZ OBARCZENI KONSEKWENCJAMI WYNIKAJCYMI Z UYCIA (WCZAJC, ALE NIE 
 * OGRANICZAJC, DOSTARCZENIE ZASTPCZYCH TOWARW LUB USUG; UTRATY PODCZAS UYCIA, 
 * DANYCH LUB KORZYCI; LUB PRZERWY W PROWADZENIU DZIAALNOCI BIZNESOWEJ). JAKKOLWIEK
 * SPOWODOWANE I NA JAKKOLWIEK TEORI ODPOWIEDZIALNOCI, CZY W KONTRAKCIE,
 * ODPOWIEDZIALNOCI CISEJ, LUB ODPOWIEDZIALNOCI ZA SZKOD WYRZDZON CZYNEM
 * NIEDOZWOLONYM (WCZAJC ZANIEDBANIE LUB COKOLWIEK INNEGO) KTRA POWSTAJE W
 * JAKIKOLWIEK SPOSB NA SKUTEK UYCIA TEGO OPROGRAMOWANIA, NAWET JELI JEST INFORMACJA  
 * O MOLIWOCI TAKIEGO USZKODZENIA.
 */
 
 /*
 * jbchroot.c
 * Polecenie chroot systemu OpenBSD przeniesione do systemw Linux i Solaris przez  
 * Jasona Brittaina.
 */
#ifndef lint
static const char copyright[] =
"@(#) Prawa autorskie (c) 1988, 1993\n\
        Wadze Uniwersytetu Kalifornijskiego.  Wszystkie prawa zastrzeone.\n";
#endif /* not lint */

#ifndef lint
#if 0
static const char sccsid[] = "@(#)chroot.c      8.1 (Berkeley) 6/9/93";
#else
static const char rcsid[] = "$OpenBSD: chroot.c,v 1.7 2002/10/29 23:12:06 millert Exp $";
#endif
#endif /* not lint */

#include <ctype.h>
#include <errno.h>
#include <grp.h>
#include <limits.h>
#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int             main(int, char **);
void            usage(char *);
static char*    getToken(char**, const char*);

int
main(int argc, char **argv)
{
  struct group        *gp;
  struct passwd        *pw;
  const char        *shell;
  char                *fulluser, *user, *group, *grouplist, *endp, *p;
  gid_t                gid, gidlist[NGROUPS_MAX];
  uid_t                uid;
  int                ch, gids;
  unsigned long        ul;
  char               *myname;

myname = argv[0];
gid = 0;
  uid = 0;
  gids = 0;
  user = fulluser = group = grouplist = NULL;
  while ((ch = getopt(argc, argv, "G:g:U:u:")) != -1) {
    switch(ch) {
    case 'U':
      fulluser = optarg;
      if (*fulluser == '\0')
    usage(myname);
      break;
    case 'u':
      user = optarg;
      if (*user == '\0')
    usage(myname);
      break;
    case 'g':
      group = optarg;
      if (*group == '\0')
    usage(myname);
      break;
    case 'G':
      grouplist = optarg;
      if (*grouplist == '\0')
    usage(myname);
      break;
    case '?':
    default:
      usage(myname);
    }
  }
  argc -= optind;
  argv += optind;

  if (argc < 1)
    usage(myname);
  if (fulluser && (user || group || grouplist)) {
    fprintf(stderr,
      "%s: Opcja -U nie moe by okrelona z dowoln inn opcj\n",
      myname);
    exit(-1);
  }

  if (group != NULL) {
    if ((gp = getgrnam(group)) != NULL)
      gid = gp->gr_gid;
    else if (isdigit((unsigned char)*group)) {
      errno = 0;
      ul = strtoul(group, &endp, 10);
      if (*endp != '\0' || (ul == ULONG_MAX && errno == ERANGE)) {
    fprintf(stderr, "%s: Niepoprawny identyfikator grupy `%s'\n", myname, group);
       exit(-1);
      }
      gid = (gid_t)ul;
    }
    else {
      fprintf(stderr, "%s: Nie ma takiej grupy `%s'\n", myname, group);
      exit(-1);
    }
    if (grouplist != NULL)
      gidlist[gids++] = gid;
    if (setgid(gid) != 0) {
      fprintf(stderr, "%s: setgid", myname);
      exit(-1);
    }
  }

  while ((p = getToken(&grouplist, ",")) != NULL && gids < NGROUPS_MAX) {
    if (*p == '\0')
      continue;

    if ((gp = getgrnam(p)) != NULL)
      gidlist[gids] = gp->gr_gid;
    else if (isdigit((unsigned char)*p)) {
      errno = 0;
      ul = strtoul(p, &endp, 10);
      if (*endp != '\0' || (ul == ULONG_MAX && errno == ERANGE)) {
    fprintf(stderr, "%s: Niepoprawny identyfikator grupy `%s'\n", myname, p);
        exit(-1);
      }
      gidlist[gids] = (gid_t)ul;
    }
    else {
      fprintf(stderr, "%s: Nie ma takiej grupy `%s'\n", myname, p);
      exit(-1);
    }
    /*
     * Zignorowanie podstawowej grupy, jeli j okrelono; grupa zostaa ju wczeniej 
     * dodana.
     */
    if (group == NULL || gidlist[gids] != gid)
      gids++;
  }
  if (p != NULL && gids == NGROUPS_MAX) {
    fprintf(stderr, "%s: Okrelono zbyt wiele dodatkowych grup\n", myname);
    exit(-1);
  }
  if (gids && setgroups(gids, gidlist) != 0) {
    fprintf(stderr, "%s: setgroups", myname);
    exit(-1);
  }

  if (user != NULL) {
    if ((pw = getpwnam(user)) != NULL)
uid = pw->pw_uid;
    else if (isdigit((unsigned char)*user)) {
      errno = 0;
      ul = strtoul(user, &endp, 10);
      if (*endp != '\0' || (ul == ULONG_MAX && errno == ERANGE)) {
    fprintf(stderr, "%s: Niepoprawny identyfikator uytkownika `%s'\n", myname, user);
        exit(-1);
      }
      uid = (uid_t)ul;
    }
    else {
      fprintf(stderr, "%s: Nie ma takiego uytkownika `%s'\n", myname, user);
      exit(-1);
    }
  }
  if (fulluser != NULL) {
    if ((pw = getpwnam(fulluser)) == NULL) {
      fprintf(stderr, "%s: Nie ma takiego uytkownika `%s'\n", myname, fulluser);
      exit(-1);
    }
    uid = pw->pw_uid;
    gid = pw->pw_gid;
    if (setgid(gid) != 0) {
      fprintf(stderr, "%s: setgid\n", myname);
      exit(-1);
    }
    if (initgroups(fulluser, gid) == -1) {
      fprintf(stderr, "%s: initgroups\n", myname);
      exit(-1);
    }
  }

  if (chroot(argv[0]) != 0 || chdir("/") != 0) {
    fprintf(stderr, "%s: %s\n", myname, argv[0]);
    exit(-1);
  }

  if ((user || fulluser) && setuid(uid) != 0) {
    fprintf(stderr, "%s: setuid\n", myname);
    exit(-1);
  }

  if (argv[1]) {
    execvp(argv[1], &argv[1]);
    fprintf(stderr, "%s: %s\n", myname, argv[1]);
    exit(-1);
  }

  if ((shell = getenv("SHELL")) == NULL)
    shell = "/bin/sh";
  execlp(shell, shell, "-i", (char *)NULL);
fprintf(stderr, "%s, %s\n", myname, shell);
  /* NIE OSIGNITE */
}

void
usage(char *myname)
{
  (void)fprintf(stderr, "Zastosowanie: %s [-g grupa] [-G grupa,grupa,...] "
        "[-u uytkownik] [-U uytkownik] newroot [polecenie]\n", myname);
  exit(1);
}

/* Zastpuje to program strsep, ktrego nie ma w systemie Solaris. */
static char* getToken(char** str, const char* delims)
{
  char* token;

  if (*str==NULL) {
    /* Nie ma wicej tokenw */
    return NULL;
  }

  token=*str;
  while (**str!='\0') {
    if (strchr(delims,**str)!=NULL) {
      **str='\0';
      (*str)++;
      return token;
    }
    (*str)++;
  }
  /* Nie ma innego tokena */
  *str=NULL;
  return token;
}