//: c15:MultiJabberClient.java
// Program klienta testujcy MultiJabberServer
// poprzez uruchomienie wielu klientw jednoczenie.
import java.net.*;
import java.io.*;

class JabberClientThread extends Thread {
  private Socket socket;
  private BufferedReader in;
  private PrintWriter out;
  private static int counter = 0;
  private int id = counter++;
  private static int threadcount = 0;
  public static int threadCount() { 
    return threadcount; 
  }
  public JabberClientThread(InetAddress addr) {
    System.out.println("Tworzenie klienta " + id);
    threadcount++;
    try {
      socket = 
        new Socket(addr, MultiJabberServer.PORT);
    } catch(IOException e) {
      System.err.println("Tworzenie gniazda nie powiodo si");
      // Jeeli tworzenie gniazda si nie uda, 
      // wtedy nie ma niczego do sprztnicia.
    }
    try {    
      in = 
        new BufferedReader(
          new InputStreamReader(
            socket.getInputStream()));
      // Wczamy automatyczne oprnianie bufora:
      out = 
        new PrintWriter(
          new BufferedWriter(
            new OutputStreamWriter(
              socket.getOutputStream())), true);
      start();
    } catch(IOException e) {
      // Gniazdo powinno by zamknite w przypadku 
      // niepowodze innych ni te zwizane z jego
      // konstruktorem:
      try {
        socket.close();
      } catch(IOException e2) {
        System.err.println("Gniazdo nie zamknite");
      }
    }
    // W przeciwnym wypadku zostanie zamknite przez
    // metod run() wtku.
  }
  public void run() {
    try {
      for(int i = 0; i < 25; i++) {
        out.println("Klient " + id + ": " + i);
        String str = in.readLine();
        System.out.println(str);
      }
      out.println("KONIEC");
    } catch(IOException e) {
      System.err.println("IO Exception");
    } finally {
      // Zawsze je zamykamy:
      try {
        socket.close();
      } catch(IOException e) {
        System.err.println("Gniazdo nie zamknite");
      }
      threadcount--; // Koczymy aktualny wtek
    }
  }
}
public class MultiJabberClient {
  static final int MAX_THREADS = 40;
  public static void main(String[] args) 
      throws IOException, InterruptedException {
    InetAddress addr = 
      InetAddress.getByName(null);
    while(true) {
      if(JabberClientThread.threadCount() 
         < MAX_THREADS)
        new JabberClientThread(addr);
      Thread.currentThread().sleep(100);
    }
  }
} ///:~
