//: c11:IOProblem.java
// Java 1.1 and higher I/O Problem.
import java.io.*;

public class IOProblem {
  // Throw exceptions to console:
  public static void main(String[] args) 
  throws IOException {
    DataOutputStream out =
      new DataOutputStream(
        new BufferedOutputStream(
          new FileOutputStream("Data.txt")));
    out.writeDouble(3.14159);
    out.writeBytes("To bya warto pi\n");
    out.writeBytes("To jest pi/2:\n");
    out.writeDouble(3.14159/2);
    out.close();

    DataInputStream in =
      new DataInputStream(
        new BufferedInputStream(
          new FileInputStream("Data.txt")));
    BufferedReader inbr =
      new BufferedReader(
        new InputStreamReader(in));
    // Liczby double zapisane przed wierszem tekstu
    // odczytuj si poprawnie:
    System.out.println(in.readDouble());
    // Odczytuj wiersz tekstu:
    System.out.println(inbr.readLine());
    System.out.println(inbr.readLine());
    // Prba odczytu liczb double po wierszu tekstu
    // powoduje zgoszenie wyjtku koca pliku:
    System.out.println(in.readDouble());
  }
} ///:~
