//: c06:CADSystem.java
// Zapewnienie waciwego sprztania.
import java.util.*;

class Shape {
  Shape(int i) {
    System.out.println("Konstruktor ksztatu");
  }
  void cleanup() {
    System.out.println("Sprztanie ksztatu");
  }
}

class Circle extends Shape {
  Circle(int i) {
    super(i);
    System.out.println("Rysowanie koa");
  }
  void cleanup() {
    System.out.println("Wymazanie koa");
    super.cleanup();
  }
}

class Triangle extends Shape {
  Triangle(int i) {
    super(i);
    System.out.println("Rysowanie trjkta");
  }
  void cleanup() {
    System.out.println("Wymazanie trjkta");
    super.cleanup();
  }
}

class Line extends Shape {
  private int start, end;
  Line(int start, int end) {
    super(start);
    this.start = start;
    this.end = end;
    System.out.println("Rysowanie linii: " +
           start + ", " + end);
  }
  void cleanup() {
    System.out.println("Wymazanie linii: " +
           start + ", " + end);
    super.cleanup();
  }
}
public class CADSystem extends Shape {
  private Circle c;
  private Triangle t;
  private Line[] lines = new Line[10];
  CADSystem(int i) {
    super(i + 1);
    for(int j = 0; j < 10; j++)
      lines[j] = new Line(j, j*j);
    c = new Circle(1);
    t = new Triangle(1);
    System.out.println("Konstruktor systemu");
  }
  void cleanup() {
    System.out.println("CADSystem.cleanup()");
    // Kolejno czyszczenia jest odwrotna
    // w stosunku do kolejnoci inicjalizacji
    t.cleanup();
    c.cleanup();
    for(int i = lines.length - 1; i >= 0; i--)
      lines[i].cleanup();
    super.cleanup();
  }
  public static void main(String[] args) {
    CADSystem x = new CADSystem(47);
    try {
      // Kod i obsuga wyjtkw ...
    } finally {
      x.cleanup();
    }
  }
} ///:~
