
//: C10:MulticastCommand.cpp {RunByHand}
// Wyodrbnianie zarzdzania zdarzeniami za porednictwem wzorca Polecenie
#include <iostream>
#include <vector>
#include <string>
#include <ctime>
#include <cstdlib>
using namespace std;

// Szkielet mechanizmu "uruchamiania" zada:
class Task {
public:
  virtual void operation() = 0;
};

class TaskRunner {
  static vector<Task*> tasks;
  TaskRunner() {} // Konstruktor prywatny czyni obiekt Singletonem
  TaskRunner& operator=(TaskRunner&); // Operacja zablokowana
  TaskRunner(const TaskRunner&); // Operacja zablokowana
  static TaskRunner tr;
public:
  static void add(Task& t) { tasks.push_back(&t); }
  static void run() {
    vector<Task*>::iterator it = tasks.begin();
    while(it != tasks.end())
      (*it++)->operation();
  }
};

TaskRunner TaskRunner::tr;
vector<Task*> TaskRunner::tasks;

class EventSimulator {
  clock_t creation;
  clock_t delay;
public:
  EventSimulator() : creation(clock()) {
    delay = CLOCKS_PER_SEC/4 * (rand() % 20 + 1);
    cout << "opnienie = " << delay << endl;
  }
  bool fired() {
    return clock() > creation + delay;
  }
};

// Klasa zdolna do generowania asynchronicznych zdarze:
class Button {
  bool pressed;
  string id;
  EventSimulator e; // Dla celw demonatracji
public:
  Button(string name) : pressed(false), id(name) {}
  void press() { pressed = true; }
  bool isPressed() {
    if(e.fired()) press(); // Symulacja zajcia zdarzenia
    return pressed;
  }
  friend ostream&
  operator<<(ostream& os, const Button& b) {
    return os << b.id;
  }
};

// obiekt Polecenia
class CheckButton : public Task {
  Button& button;
  bool handled;
public:
  CheckButton(Button & b) : button(b), handled(false) {}
  void operation() {
    if(button.isPressed() && !handled) {
      cout << button << " nacinity" << endl;
      handled = true;
    }
  }
};

// Procedury realizujce gwne operacje programu. Powinny by
// od czasu do czasu "przerywane" w celu sprawdzenia stanu
// przyciskw i innych zdarze:
void procedure1() {
  // Wykonywanie operacji
  // ...
  TaskRunner::run(); // Sprawdzenie stanu zdarze
}

void procedure2() {
  // Wykonywanie innych operacji.
  // ...
  TaskRunner::run(); // Sprawdzenie stanu zdarze
}

void procedure3() {
  // Wykonywanie jeszcze innych operacji.
  // ...
  TaskRunner::run(); // Sprawdzenie stanu zdarze
}

int main() {
  srand(time(0)); // Inicjalizacja generatora pseudolosowego
  Button b1("Przycisk 1"), b2("Przycisk 2"), b3("Przycisk 3");
  CheckButton cb1(b1), cb2(b2), cb3(b3);
  TaskRunner::add(cb1);
  TaskRunner::add(cb2);
  TaskRunner::add(cb3);
  cout << "Nacinij Control-C, aby zakoczy" << endl;
  while(true) {
    procedure1();
    procedure2();
    procedure3();
  }
} ///:~
