
//: C07:Stack2.cpp
// Konwersja listy do postaci stosu
#include <iostream>
#include <fstream>
#include <stack>
#include <list>
#include <string>
#include <cstddef>

using namespace std;

// Funkcja przyjmuje stos (obiekt klasy stack):
template<class Stk>
void stackOut(Stk& s, ostream& os = cout) {
  while(!s.empty()) {
    os << s.top() << "\n";
    s.pop();
  }
}

class Line {
  string line; // Bez pocztkowych znakw odstpu
  size_t lspaces; // Liczba pocztkowych znakw odstpu
public:
  Line(string s) : line(s) {
    lspaces = line.find_first_not_of(' ');
    if(lspaces == string::npos)
      lspaces = 0;
    line = line.substr(lspaces);
  }
  friend ostream&
  operator<<(ostream& os, const Line& l) {
    for(int i = 0; i < l.lspaces; i++)
      os << ' ';
    return os << l.line;
  }
  // Reszta operacji...
};

int main() {
  ifstream in("Stack2.cpp");
  list<Line> lines;
  // Wczytanie zawartoci pliku i umieszczenie wierszy tekstu w kontenerze list:
  string s;
  while(getline(in, s))
    lines.push_front(s);
  // Zamiana listy na stos:
  stack<Line, list<Line> > stk(lines);
  stackOut(stk);
} ///:~
