
//: C07:SimpleGenerators.h
// Uoglnione generatory, w tym generator
// tworzcy obiekty typu pair
#include <iostream>
#include <utility>

// Generator inkrementujcy wartoci kolejnych elementw:
template<typename T>

class IncrGen {
  T i;
public:
  IncrGen(T ii) : i (ii) {}
  T operator()() { return i++; }
};

// Generator tworzcy konkretyzacje szablonu pair<>:
template<typename T1, typename T2>
class PairGen {
  T1 i;
  T2 j;
public:
  PairGen(T1 ii, T2 jj) : i(ii), j(jj) {}
  std::pair<T1,T2> operator()() {
    return std::pair<T1,T2>(i++, j++);
  }
};

namespace std {
// Uoglniony operator operator<<
// sucy do zapisu skadowych pary we wskazanym strumieniu:
template<typename F, typename S> ostream&
operator<<(ostream& os, const pair<F,S>& p) {
  return os << p.first << "\t"
    << p.second << endl;
}
} ///:~
