
//: C07:RawStorageIterator.cpp
// Demonstracja wykorzystania iteratora raw_storage_iterator
//{-bor}
#include <iostream>
#include <iterator>
#include <algorithm>
#include "Noisy.h"
using namespace std;

int main() {
  const int quantity = 10;
  // Przydzia obszaru pamici i rzutowanie wskanika na typ obiektu:
  Noisy* np =
    reinterpret_cast<Noisy*>(
      new char[quantity * sizeof(Noisy)]);
  raw_storage_iterator<Noisy*, Noisy> rsi(np);
  for(int i = 0; i < quantity; i++)
    *rsi++ = Noisy(); // Umieszczenie obiektu w pamici
  cout << endl;
  copy(np, np + quantity,
    ostream_iterator<Noisy>(cout, " "));
  cout << endl;
  // Jawne wywoanie destruktora w procesie czyszczenia obszaru pamici:
  for(int j = 0; j < quantity; j++)
    (&np[j])->~Noisy();
  // Zwolnienie obszaru pamici:
  delete reinterpret_cast<char*>(np);
} ///:~

