
//: C07:MapVsHashMap.cpp
// Nagwek definiujcy kontener hash_map nie jest czci
// biblioteki standardowej jzyka C++. Jest to rozszerzenie
// dostpne w ramach implementacji tej biblioteki w wydaniu
// firmy SGI (dostpnej w ramach dystrybucji kompilatora g++)
//{-bor} Mona rcznie doda stosowny nagwek
//{-msc} Mona rcznie doda stosowny nagwek
//{-g++} Mona rcznie doda stosowny nagwek
#include <hash_map>
#include <iostream>
#include <map>
#include <ctime>
using namespace std;

int main(){
  hash_map<int, int> hm;
  map<int, int> m;
  clock_t ticks = clock();
  for(int i = 0; i < 100; i++)
    for(int j = 0; j < 1000; j++)
      m.insert(make_pair(j,j));
  cout << "wstawianie do kontenera map: "
    << clock() - ticks << endl;
  ticks = clock();
  for(int i = 0; i < 100; i++)
    for(int j = 0; j < 1000; j++)
      hm.insert(make_pair(j,j));
  cout << "wstawianie do kontenera hash_map: "
    << clock() - ticks << endl;
  ticks = clock();
  for(int i = 0; i < 100; i++)
    for(int j = 0; j < 1000; j++)
      m[j];
  cout << "wyszukiwanie w kontenerze map za pomoc operatora indeksowania: "
    << clock() - ticks << endl;
  ticks = clock();
  for(int i = 0; i < 100; i++)
    for(int j = 0; j < 1000; j++)
      hm[j];
  cout << "wyszukiwanie w kontenerze hash_map za pomoc operatora indeksowania: "
    << clock() - ticks << endl;
  ticks = clock();
  for(int i = 0; i < 100; i++)
    for(int j = 0; j < 1000; j++)
      m.find(j);
  cout << "wyszukiwanie metod find() w kontenerze map: "
    << clock() - ticks << endl;
  ticks = clock();
  for(int i = 0; i < 100; i++)
    for(int j = 0; j < 1000; j++)
      hm.find(j);
  cout << "wyszukiwanie metod find() w kontenerze hash_map: "
    << clock() - ticks << endl;
} ///:~
